% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rand_gen.R
\name{random_init_simplex}
\alias{random_init_simplex}
\title{Generates a random point in the (p-1)-simplex.}
\usage{
random_init_simplex(p, rdist = stats::rnorm, tol = 1e-10, maxtimes = 100)
}
\arguments{
\item{p}{An integer, the dimension.}

\item{rdist}{A function that generates a random number when called using \code{rdist(1)}. Must return a non-zero number with a large enough probability.}

\item{tol}{A small positive number. Samples are regenerated until each of the \code{p} components are at least of size \code{tol}.}

\item{maxtimes}{An integer, maximum number of attempts.}
}
\value{
A random point (\code{p}-vector) in the \code{(p-1)}-simplex, i.e. \code{sum(x) == 1 && x > 0}.
}
\description{
Generates a random point in the \code{(p-1)}-simplex.
}
\details{
\code{p} numbers are generated from \code{rdist} and their absolute values are normalized to sum to 1. This will be repeated up to \code{maxtimes} times until all \code{p} components are larger than or equal to \code{tol}.
}
\examples{
random_init_simplex(100, stats::rnorm, 1e-10, 100)
}
