% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/domain.R
\name{check_endpoints}
\alias{check_endpoints}
\title{Checks if two equally sized numeric vectors satisfy the requirements for being left and right endpoints of a domain defined as a union of intervals.}
\usage{
check_endpoints(lefts, rights)
}
\arguments{
\item{lefts}{A non-empty vector of numbers (may contain \code{-Inf}), the left endpoints of a domain defined as a union of intervals.}

\item{rights}{A non-empty vector of numbers (may contain \code{Inf}), the right endpoints of a domain defined as a union of intervals. Must have the same size as \code{lefts}.}
}
\value{
\code{NULL}. Program stops if \code{lefts} and \code{rights} do not define valid left and right endpoints.
}
\description{
Checks if two equally sized numeric vectors satisfy the requirements for being left and right endpoints of a domain defined as a union of intervals.
}
\details{
Both \code{lefts} and \code{rights} must be non-empty and should have the same length.
Suppose \code{lefts} and \code{rights} both have length l, [lefts[1], rights[1]], ..., [lefts[l], rights[l]] must be an increasing and non-overlapping set of valid intervals, meaning lefts[i] <= rights[i] <= lefts[j] for any i < j (singletons and overlapping at the boundary points are allowed).
\code{Inf} is not allowed in \code{lefts} and \code{-Inf} is not allowed in \code{rights}.
}
\examples{
## [-4,-3], [-2,-1], [0,1], [2,3], [4,5]
check_endpoints(lefts=c(-4,-2,0,2,4), rights=c(-3,-1,1,3,5))
\dontrun{
check_endpoints(lefts=c(), rights=c()) # Cannot be empty
check_endpoints(lefts=c(-4,-2,0,2,4), rights=c(-3,-1,1,3)) # Unequal length
check_endpoints(lefts=c(Inf), rights=c(Inf)) # No Inf in lefts, otherwise invalid interval
check_endpoints(lefts=c(-Inf), rights=c(-Inf)) # No -Inf in rights, otherwise invalid interval
check_endpoints(lefts=c(0, 1), rights=c(2, 3)) # [0,2] and [1,3] overlap, not allowed
check_endpoints(lefts=c(2, 0), rights=c(3, 1)) # [2,3], [0,1] not increasing, not allowed
}
## Singletons and overlapping at the boundary points allowed
check_endpoints(lefts=c(0, 1, 2), rights=c(0, 2, 3))
}
