% Generated by roxygen2 (4.0.2): do not edit by hand
\name{print.xtree.pls}
\alias{print.xtree.pls}
\title{Print function for the Pathmox Segmentation Trees: PLS-PM}
\usage{
\method{print}{xtree.pls}(x, ...)
}
\arguments{
\item{x}{An object of class \code{"xtree.pls"}.}

\item{\dots}{Further arguments are ignored.}
}
\description{
The function \code{print.xtree.pls} print the \code{pls.pathmox} tree
}
\examples{
\dontrun{
 ## example of PLS-PM in alumni satisfaction

 data(fibtele)

 # select manifest variables
 data.fib <-fibtele[,12:35]

 # define inner model matrix
 Image 			= rep(0,5)
	Qual.spec		= rep(0,5)
	Qual.gen			= rep(0,5)
	Value			= c(1,1,1,0,0)
	Satis			= c(1,1,1,1,0)
 inner.fib <- rbind(Image,Qual.spec, Qual.gen, Value, Satis)
 colnames(inner.fib) <- rownames(inner.fib)

 # blocks of indicators (outer model)
 outer.fib <- list(1:8,9:11,12:16,17:20,21:24)
 modes.fib  = rep("A", 5)

 # apply plspm
 pls.fib <- plspm(data.fib, inner.fib, outer.fib, modes.fib)


 # re-ordering those segmentation variables with ordinal scale
  seg.fib= fibtele[,2:11]

	seg.fib$Age = factor(seg.fib$Age, ordered=T)
	seg.fib$Salary = factor(seg.fib$Salary,
			levels=c("<18k","25k","35k","45k",">45k"), ordered=T)
	seg.fib$Accgrade = factor(seg.fib$Accgrade,
			levels=c("accnote<7","7-8accnote","accnote>8"), ordered=T)
	seg.fib$Grade = factor(seg.fib$Grade,
	levels=c("<6.5note","6.5-7note","7-7.5note",">7.5note"), ordered=T)

 # Pathmox Analysis
 fib.pathmox=pls.pathmox(pls.fib,seg.fib,signif=0.05,
					deep=2,method="lm",size=0.2,n.node=20)


 print(fib.pathmox)
 }
}
\author{
Giuseppe Lamberti
}
\references{
Lamberti, G. (2014) \emph{Modeling with Heterogeneity.} PhD Dissertation.


\code{\link{summary.xtree.pls}}.
}

