% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetChromosome.R
\name{subsetChromosome}
\alias{subsetChromosome}
\title{Subset genotypeR object by chromosome}
\usage{
subsetChromosome(aa, chromosome)
}
\arguments{
\item{aa}{genotypeR object before binary coding}

\item{chromosome}{which chromosome to pull out (e.g., "chr2")}
}
\value{
A genotypeR object subset based on the pattern supplied with chromosome
}
\description{
\code{subsetChromosome} subsets a genotypeR object based on
the supplied chromosome name (must be the same as that in the data).
}
\examples{

data(genotypes_data)
data(markers)
## genotype table
marker_names <- make_marker_names(markers)
GT_table <- Ref_Alt_Table(marker_names)
## remove those markers that did not work
genotypes_data_filtered <- genotypes_data[,c(1, 2, grep("TRUE",
colnames(genotypes_data)\%in\%GT_table$marker_names))]

warnings_out2NA <- initialize_genotypeR_data(seq_data = genotypes_data_filtered,
genotype_table = GT_table, output = "warnings2NA")
chromosome_subset <- subsetChromosome(warnings_out2NA, "chr2")

}
\keyword{by}
\keyword{chromosome}
\keyword{genotypeR}
\keyword{object}
\keyword{subset}
