% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/illumina_Genotype_Table.R
\name{illumina_Genotype_Table}
\alias{illumina_Genotype_Table}
\title{Make genotypeR Alt_Ref_Table}
\usage{
illumina_Genotype_Table(tab_delimited_file, flanking_region_length, chromosome)
}
\arguments{
\item{tab_delimited_file}{is a tab delimited AB illumina GoldenGate file}

\item{flanking_region_length}{is the length in bp of the flanking region of the SNP}

\item{chromosome}{is a vector of chromosome names}
}
\value{
data frame useful used in genotypeR
}
\description{
\code{illumina_Genotype_Table} produces the Alt_Ref_Table needed
by \code{initialize_genotypeR_data} from illumina's
goldengate platform.
}
\examples{
\dontrun{
##Files not included to provide working example
test_data <- read_in_illumina_GoldenGate(tab_delimited_file="path_to_goldengate_file"
, flanking_region_length=50, chromosome=rep("chr2",
length.out=length(552960)))
illumina_table <- illumina_Genotype_Table(tab_delimited_file= \\
"path_to_goldengate_file", flanking_region_length=50,
chromosome=rep("chr2", length.out=length(552960)))
}
}
\keyword{GoldenGate}
\keyword{illumina}
