% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genodds.power.R
\name{genodds.power}
\alias{genodds.power}
\title{Power Calculations for Generalized Odds Ratios}
\usage{
genodds.power(
  p0,
  p1,
  N = NULL,
  power = NULL,
  alpha = 0.05,
  ties = "split",
  w = c(0.5, 0.5),
  direction = "two.sided"
)
}
\arguments{
\item{p0}{A numeric vector containing the probabilities in control group.}

\item{p1}{A numeric vector containing the probabilities in treatment group.}

\item{N}{A numeric vector containing total sample sizes.}

\item{power}{A numeric vector containing required  total sample size.}

\item{alpha}{Type 1 error.}

\item{ties}{A string specifying how ties should be treated.}

\item{w}{A numeric vector of length 2 specifying the relative weighting
of sample size between treatment groups.}

\item{direction}{Direction for hypothesis test.
Must be one of \code{"two.sided"},\code{"upper.tail"} or \code{"lower.tail"}.}
}
\value{
\describe{
    \item{If \code{power} is supplied}{A numeric vector containing required sample sizes to achieve specified powers.}
    \item{If \code{N} is supplied}{A numeric vector containing power at specified sample sizes.}
}
}
\description{
Provides power analysis for Agresti's Generalized Odds Ratios.
}
\details{
See \code{\link{genodds}} for explanation of generalized odds ratios.

\code{N} provides the total sample size.
Sample size per group can be calculated by \code{N*w/sum(w)}.

When \code{power} is supplied, if no sufficient sample size is
found then this function will return \code{Inf}.
}
\examples{

# Provide theoretical distributions of outcomes for each group
# Distributions taken from Lees et. al. (2010). See ?alteplase for a citation.
p0 <- c(0.224,0.191,0.082,0.133,0.136,0.043,0.191)
p1 <- c(0.109,0.199,0.109,0.120,0.194,0.070,0.200)

# Calculate sample size required to achieve 80\% and 90\%
# power for these distributions
genodds.power(p0,p1,power=c(0.8,0.9))

# genodds.power suggests a total sample size of 619 for 80\% power.
# Round up to 620 for even sample size per group

# Confirm these sample sizes lead to 80\% and 90\% power
genodds.power(p0,p1,N=c(620,830))

}
\references{
O'Brien, R. G., & Castelloe, J. (2006, March).
Exploiting the link between the Wilcoxon-Mann-Whitney test and a simple odds statistic.
In \emph{Thirty-first Annual SAS Users Group International Conference}.
}
