% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/albums.R
\name{get_album_df}
\alias{get_album_df}
\title{Retrieve meta data for an album}
\usage{
get_album_df(album_id, access_token = genius_token())
}
\arguments{
\item{album_id}{ID of the album (\code{album_id} within an object returned by
\code{\link{get_song}})}

\item{access_token}{Genius' client access token, defaults to \code{genius_token}}
}
\value{
a tibble
}
\description{
The Genius API lets you return data for a specific album, given an album ID.
\code{get_album_meta} returns this data in a tidy, but reduced, format.
}
\examples{
\dontrun{
get_album_df(album_id = 337082)
}
}
\seealso{
See \code{\link{get_album}} to return extended data as a list.

Other album: 
\code{\link{get_album_tracklist_id}()},
\code{\link{get_album_tracklist_search}()},
\code{\link{get_album}()}
}
\concept{album}
