# $Id: genotype.R,v 1.21 2002/11/27 15:32:20 warnesgr Exp $
#
# $Log: genotype.R,v $
# Revision 1.21  2002/11/27 15:32:20  warnesgr
# Correct spelling errors and typos.
#
# Revision 1.20  2002/11/12 19:59:24  warnesgr
#
# - Changes to remove warnings generated by 'R CMD check'.
#
# Revision 1.19  2002/11/12 05:31:20  warnesgr
# - Fix mismatches between documentation and code that we generating
#   warning messages.
#
# Revision 1.18  2002/11/08 21:07:28  warnesgr
#
# - DESCRIPTION: Updated version number and date
# - TODO: Updated todo list.
#
# Revision 1.17  2002/10/28 18:20:18  warnesgr
# - Allow allele names to be specified for as.genotype.allele.count().
#
# Revision 1.16  2002/10/24 21:43:01  warnesgr
#
# - Fixed bug as.genotype.alllele.count() introduced when 'harmonizing' methods
#   with generics.
# - Added 'alleles' arguments to the as.genotype.alllele.count() function.
# - Added example code for as.genotype.alllele.count() to doc file.
# - Added explicit mention of as.genotype.alllele.count() to doc file.
#
# Revision 1.15  2002/09/24 01:32:19  warnesgr
# - 'Un-genericized' diseq()
# - Moved documentation of diseq() and diseq from HWE.test.Rd to diseq.Rd
# - Cleaned up HWE.test.Rd and diseq.Rd
# - Fixed broken class check in diseq() and diseq.ci()
# - Removed allele.count.default() -- this will force the user to
#   explicitly call 'genotype' on the data to use allele.count().
# - Added zzz.R to require package 'boot'
#
# Revision 1.14  2002/09/23 20:08:34  warnesgr
#
# - Added as.genotype.table()
#
# Revision 1.13  2002/06/18 20:41:50  warnesgr
#
# - Fixed a bug in allele.count that resulted in infinite recuresion.
# - Modified documentation to match changed code.
#
# Revision 1.12  2002/06/18 19:38:41  warnesgr
#
# Changes to fix problems reported by R CMD check.
#
# Revision 1.11  2002/04/08 23:19:36  warneg
# - Modified 'genotype' function so that when the user specifies the
#   alleles non-matching elements are converted to NAs.
#
# Revision 1.10  2002/02/21 03:09:02  warnes
#
# - Add as.factor.genotype.
#
# Revision 1.9  2002/02/14 12:55:14  warnes
#
# Fixed bugs in [.genotype and [.haplotype.
#
# - There was a serious typo that would have been cought had I just done
#   R CMD check.
#
# - Revamped [.genotype and [.haplotype to work correctly and to avoid
#   the overhead of calling genotype() or haplotype() when drop=T.  I
#   think these finally work properly.
#
# Revision 1.8  2002/02/09 00:47:34  warnes
#
# - Fixed the changes to "[.genotype" and "[.haplotype".  I was
#   incorrectly coping *all* of the attributes in the case of drop=T.
#   This caused mis-labeling of the underlying factor levels.
#
# Revision 1.7  2002/02/07 16:57:37  warnes
#
# Fixed two bugs
#
# 1) "[.genotype" and "[.haplotype" didn't have the 'drop' argument, so
#    an error would be generated when used in a context that expected it (like
#    lm(..., subset=something) ).
#
#    I've implemented these so that drop=T not only drops unused factor
#    levels, but also drops unused *allele* levels.
#
# 2) "==.genotype" and "==.haplotype" didn't handle second arguments that
#    weren't genotypes / haplotypes, so
#       x <- genotype( "A/B" )
#       x == "A/B"
#    would generate an error.  Solved by converting the y argument to a
#    genotype / haplotype before the comparison.
#
#    Note that if the lhs is a genotype  this means
#       x == "A/B"
#    and
#       x == "B/A"
#    give the identical results.
#
# Revision 1.6  2001/06/28 19:23:45  warnes
#
# Minor change, mask off extra attributes when calling print() to
# dislplay genotype data.
#
# Revision 1.5  2001/06/15 17:02:20  warnes
#
# - Modified HWE.test to use chisq.test.  Added a modified version of
#   chisq.test until the (minor) changes show up in ctest.
#
# - Fixed documentation links and alias omissions
#
# - Fixed getallele() to snag allele element or attribute if either is
#   present.  This makes it work for summary.genotype as well as for
#   genotype.
#
# Revision 1.4  2001/05/30 22:12:34  warnes
# Updated documentation mostly.  Added as.character.genotype().
#
# Revision 1.3  2001/05/26 00:26:20  warnes
#
# Removed allele.ind() and added "any" parameter to carrier().  When
# more than one allele is selected, or when no alleles are slected and
# any=F, carrier() now acts as allele.ind() did.
#
# Modified allele.count() to have similar behavior.
#
# Revision 1.1  2001/05/22 18:53:17  warnes
# - Renamed "genotype.R" from "Genomics.R".
#
# - Added slot for "locus" into genotype class.
#
# - Made allele.count, allele.ind, heterozygote, homozygote, and carrier
#   return objects with the same class and created print.X routines.
#   This enabled the next item..
#
# - Made "locus" propagate to summary, HWE.test, allele, allele.count,
#   allele.ind, heterozygote, homozygote, and carrier. This should make
#   it easier to keep track of what locus each of these correspond to.
#   **This may create unanticipated side effects**
#
# Revision 1.4  2001/05/16 12:58:48  leisch
# cosmetics
#
# Revision 1.3  2001/05/16 12:55:14  leisch
# genotype: bugfix for non-character allele vectors (e.g., integers)
#           a2 is now ignored if a1 is a genotype
#           a1 can now also be a 2 column matrix of alleles
#
# Revision 1.2  2001/05/10 16:07:28  leisch
# cosmetics
#
# Revision 1.1  2001/05/07 13:21:32  warnes
# Imported R code for
#
#  - Genotype and Haplotype classes,
#  - corresponding summary function (gives allele and genotype frequencies)
#  - Hardy-Weinberg Equilibrium testing.
#
# Also, a initial try at a Gene and Marker classes.
#
# Revision 1.12  2001/05/02 21:43:40  warneg
#
# - Fixed bug in "[<-.genotype".  It was creating "allele.map" transposed.
#
# - Added "[.genotype" to properly handle subsetting genotype/haplotype
# objects
#
# Revision 1.11  2001/05/02 21:27:41  warneg
#
# - Changed internal format of genotype class by removing "a1" and "a2"
# attributes which had contained the first and second alleles.  Instead,
# store a matrix with rows corresponding to factor codes and columns
# giving the allele values as suggested by Fritz Leisch.  This change
# reduces the storage requirements and makes it easier to update
# elements of a genotype vector.  Changed other functions appropriately.
#
# Note that allele values should now be obtained by the calls
# allele(x,1) and allele(x,2).
#
# - Renamed attribute "alleles" to "allele.names" and replacing most
# explicit access with allele.names() calls.
#
# - Added "[<-.genotype" and "[<-.haplotype" to handle asignment into
# genotype and haplotype vectors.
#
# - Fixed a bug in genotype when sep="".  genotype( "AA", sep="") was
# giving "AA/NULL" rather than "A/A".
#
# - Added functions heterozygote(), homozygote(), and carrier() to allow
# easy grouping based on genotypes.
#
# Revision 1.10  2001/05/01 14:33:19  warneg
#
# Updated files to use changed PG database output format.  The new format is
#
#    Patient ID,Gene,Marker,Allele1/Allele2
#
# Before it was
#
#    Patient ID,Gene,Marker,Count of Allele1,Count of Allele2,Count of Allele 3, ...
#
# This involved changes in  Allele_Freq.R, HWE_Test.R, and test.data.txt
#
# ---
#
# Modified Examples.R to remove random values.  This will allow
# diffing current and previous versions of the code to check for
# regressions.
#
# ---
#
# Fixed as.genotype.allele.count() to handle conversions both when when NA values
# are and are not obtained.
#
# Simplified the class type of HWE.test results to "HWE.test" from
# "HWE.test.allele.freq".
#
# Revision 1.9  2001/04/25 21:32:00  warneg
# Added Examples.out file giving the output of some tests.  This can be used
# to check for regressions when code is changed.
#
# Revision 1.8  2001/04/25 18:35:47  warneg
# Added allele.count.2.genotype as an alias for as.genotype.allele.count.
#
# Revision 1.7  2001/04/25 17:49:16  warneg
# Moved example data to a separate file "Examples.R".
#
# Revision 1.6  2001/04/23 19:37:35  warneg
# Added code to create/manipulate "genotype" and "haplotype" classes.
# This change makes it possible to properly and easily handle data of
# the form c("C/T","T/T", "C/C") rather than the "indicator" format used
# previously.  Methods are provided to convert back and forth.
#
# Revision 1.5  2001/02/07 14:47:01  warneg
#
# Corrected error that occured when only the data file contained only
# one gene+marker.
#
# Revision 1.4  2001/02/06 23:11:58  warneg
#
#
# Changed default parameters of HWE.teset.allele.freq to remove unimplemented
# statistical methods.  These will be added later.
#
# Revision 1.3  2001/02/06 18:34:24  warneg
#
#
# Added classes to handle Hardy-Weinberg Equilibrium for several markers
# (marker.freq object) and made other minor display changes.
#
# Revision 1.2  2001/02/06 17:02:06  warneg
#
#
# Added Hardy-Weinberg Equilibrium test function (HWE.test.allele.freq).
# This currently does not user the "chisq.test" function provided by R.
# Use of this function should be explored.
#
#




genotype  <- function(a1, a2=NULL, alleles=NULL, sep="/",
                      remove.spaces=TRUE,
                      reorder=c("yes", "no", "default", "ascii", "freq"),
                      allow.partial.missing=TRUE,
                      locus=NULL)                    
{
    if(missing(reorder))
      reorder  <- "freq"
    else
      reorder <- match.arg(reorder)
    
    if(is.genotype(a1)){
        a1  <-  as.character(a1)
        ## ignore a2
        a2 <- NULL
    }
    else
        mode(a1) <- "character"
    
    if(!is.null(a2))
        mode(a2) <- "character"
    
    if(remove.spaces)
    {
        a1dim <- dim(a1)
        a1  <-  gsub("[ \t]", "", a1)
        dim(a1) <- a1dim
        if(!is.null(a2))
            a2  <-  gsub("[ \t]", "", a2)
    }
    
    if(!is.null(dim(a1)) && ncol(a1) > 1)
        parts <- a1[,1:2]
    else if(!is.null(a2))
        parts  <- cbind(a1,a2)
    else
      {
        # if sep is empty, assume allele names are single characters
        # pasted together
        if(sep=="")
          sep  <- 1

        # Based on the value of sep, reformat into our standard
        # name-slash-name format
        if (is.character(sep) )
          {
            part.list   <- strsplit(a1,sep)

            ## Handle missing / empty values correctly. 
            ## Without this, empty elements are silently dropped
            ## and/or cause errors

            # only first field was given
            half.empties  <- lapply(part.list, length)==1
            part.list[half.empties]  <-  lapply(part.list[half.empties],c,NA)
            
            # neither field was given
            empties  <- is.na(a1) | lapply(part.list, length)==0
            
            part.list[empties]  <- list( c(NA,NA))
            part.list[empties]  <- list( c(NA,NA))

            parts <- matrix(unlist(part.list),ncol=2,byrow=TRUE)

          }
        else if (is.numeric(sep))
          parts  <- cbind( substring(a1,1,sep), substring(a1,sep+1,9999))
        else
          stop(paste("I don't know how to handle sep=",sep))
      }

    temp  <- gsub("[ \t]", "", parts)
    
    parts[temp==""]  <-  NA
    parts[parts=="NA"]  <-  NA

    if(!allow.partial.missing)
      parts[is.na(parts[,1]) | is.na(parts[,2]),]  <- c(NA,NA)
    
    if(missing(alleles) || is.null(alleles))
      alleles <- unique(na.omit(parts))
    else
      {
        found.alleles  <- unique(na.omit(parts))
        which.alleles  <- is.na(match(found.alleles, alleles))
        if(any(which.alleles))
          {
            warning("Found data values not matching specified alleles. Converting to NA.")
            parts[parts %in% found.alleles[which.alleles]] <- NA
          }
      }

    if(reorder!="no")
    {
        if(reorder=="ascii")
        {
            alleles <-  sort(alleles)
        }
        else if(reorder=="freq")
        {
            ## get reordering of alleles by frequency
            tmp  <- names(rev(sort(table(parts))))
            alleles  <- unique(c(tmp,alleles))
        }

        reorder  <- function( x, alleles)
        {
            tmp <- match( x, alleles )
            x[order(tmp)]
        }
        
        parts  <- t(apply(parts,1, reorder, alleles))

      }

    
    tmp  <-  ifelse( is.na(parts[,1]) & is.na(parts[,2]),
                    NA,
                    apply(parts,1,paste,collapse="/") )
        
    object  <- factor( tmp )

    # force "NA" not to be a factor level
    ll  <- levels(object)  <-  na.omit(levels(object))
    
    class(object)  <-  c("genotype","factor")
    attr(object,"allele.names")  <- alleles
    attr(object,"allele.map")  <- do.call("rbind", strsplit(ll, "/"))
    if(is.null(locus) || is.locus(locus)  )
      attr(object,"locus")  <- locus
    else
      stop("parameter locus must be of class locus")
    return(object)
  }

is.genotype  <- function(x)
    inherits(x, "genotype")

is.haplotype  <- function(x)
    inherits(x, "haplotype")


###
### Haplotype -- differs only in that order of a1,a2 is considered siginificant
###
haplotype <- function(a1, a2=NULL, alleles=NULL, sep="/",
                      remove.spaces=TRUE,
                      reorder="no",
                      allow.partial.missing=TRUE,
                      locus=NULL)
{
    retval <- genotype(a1=a1,a2=a2,alleles=alleles,sep=sep,
                       remove.spaces=remove.spaces,reorder=reorder,
                       allow.partial.missing=allow.partial.missing,
                       locus=locus)
    class(retval)  <- c("haplotype","genotype","factor")
    retval
}

as.haplotype  <- function(x,...)
{
    retval <- as.genotype(x,...,reorder="no")
    class(retval)  <- c("haplotype","genotype","factor")
    retval
}
 
###
### Display by giving values plus list of alleles
###

print.genotype  <-  function(x,...)
  {
    if(!is.null(attr(x,"locus")))
        print(attr(x,"locus"))
    print(as.character(x))
    cat("Alleles:", allele.names(x), "\n" )
    invisible(x)
  }

###
### Conversion Functions
###

as.genotype  <- function (x,...) 
  UseMethod("as.genotype")

# Do we want to do this?
as.genotype.default  <-  function(x,...)
  genotype(x,...)

#  stop("No method to convert this object to a genotype")

# for characters, and factors, just do the standard thing (factors get
# implicitly converted to characters so both have the same effect.
as.genotype.character  <-  function(x,...)
  genotype(x,...)

as.genotype.factor  <-  function(x,...)
  genotype(as.character(x),...)

as.genotype.genotype  <- function(x,...)
  return(x)

as.genotype.haplotype  <- function(x,...)
  return(x)


## genotype.allele.counts give the count of each allele type as a
## matrix.  Collapse back into the form we need

as.genotype.allele.count  <- function(x, alleles=c("A","B"), ...)
  {
    if(!is.matrix(x) & !is.data.frame(x) )
      {
        x  <- cbind(x, 2-x)
        colnames(x)  <- alleles
      }

    if(any(x > 2, na.rm=TRUE) || any( x < 0, na.rm=TRUE ) )
      stop("Allele counts must be in {0,1,2}")
    
    allele.names  <-  colnames(x)
    tmp  <-  apply(x, 1, function(y)
                    rep( colnames(x), ifelse(is.na(y), 0, y) ))

    if(!is.matrix(tmp))
      retval  <-  genotype(sapply(tmp,paste,collapse="/"), alleles=alleles, ...)
    else
      retval  <- genotype(a1=tmp[1,], a2=tmp[2,], ... )
    return(retval)
  }

allele.count.2.genotype  <-  function(...)
  as.genotype.allele.count(...)



as.genotype.table <- function(x, alleles, ...)
  {
    #if(missing(alleles)) alleles <- unique(unlist(dimnames(x)))
    tmp <- outer( rownames(x), colnames(x), paste, sep="/")
    retval <- genotype( rep(tmp,x), alleles=alleles )
    retval
  }


###
### Equality test for genotype, assumes allele order is _not_ significant
###
"==.genotype"  <-  function(x,y)
  {
    if(!is.genotype(y))
      y <- as.genotype(y)
    
    x.a1  <- allele(x,1)
    x.a2  <- allele(x,2)
    
    y.a1  <- allele(y,1)
    y.a2  <- allele(y,2)
    
    return( (x.a1==y.a1 & x.a2==y.a2) | (x.a1==y.a2 & x.a2==y.a1) )
  }

###
### Equality test for haplotype, assumes allele order _is_ significant
###
"==.haplotype"  <-  function(x,y)
  {
    if(!is.genotype(y))
      y <- as.haplotype(y)
    
    x.a1  <- allele(x,1)
    x.a2  <- allele(x,2)

    y.a1  <- allele(y,1)
    y.a2  <- allele(y,2)
    
    return( x.a1==y.a1 & x.a2==y.a2 )
  }
###
### Extract the first and/or second allele.
###
### By default, return a 2 column matrix containing both alleles
###

#allele  <- function (x,...) 
#  UseMethod("allele")


#allele.genotype  <-  function(x, which=c(1,2) )
allele  <-  function(x, which=c(1,2) )
  {
    alleles.x  <- attr(x,"allele.map")
    retval  <- alleles.x[codes(x),which]
    attr(retval,"locus")  <- attr(x,"locus")
    attr(retval,"which")  <- which
    attr(retval,"allele.names")  <- allele.names(x)    
    #class(retval)  <- c("allele.genotype", class(retval))
    return( retval)
  }

as.factor  <- function(x, ...)
  UseMethod("as.factor")

as.factor.default  <- get("as.factor",pos="package:base")
formals(as.factor.default) <- c(formals(as.factor.default),alist(...= ))

as.factor.genotype <- function(x, ...)
  {
    attr(x,"class") <- "factor"
    attr(x,"allele.names") <- NULL
    attr(x,"allele.map") <- NULL
    attr(x,"locus") <- NULL
    x
  }

as.factor.allele.genotype  <-  function(x,...)
  factor(x,levels=allele.names(x))
                    
print.allele.genotype  <- function(x,...)
  {
    if(!is.null(attr(x,"locus")))
      print(attr(x,"locus"))
    cat("Allele(s):", attr(x,"which"), "\n")
    attr(x, "which")  <-  attr(x, "class") <- attr(x,"locus") <- attr(x,"allele.names")  <- NULL
    NextMethod("print",x)
  }


###
### Obtain the count of the number of copies of alleles for each individual
###
### By default, return a matrix containing the counts for all possible allele values.
###

#allele.count  <- function (x,...) 
#  UseMethod("allele.count")

#allele.count.default <- function (x, ... )
#  {
#    x <- as.genotype(x)
#    allele.count(x, ...)
#  }

#allele.count.genotype  <- function(x, allele.name=allele.names(x),

allele.count  <- function(x, allele.name=allele.names(x),
                          any=!missing(allele.name), na.rm=FALSE)
{
  if(!missing(allele.name) && length(allele.name)==1)
    {
      a.1  <- allele(x,1)
      a.2  <- allele(x,2)

      retval  <- ifelse(is.na(a.1) | is.na(a.2),
                        ifelse(na.rm, 0, NA),
                        (a.1==allele.name) + (a.2==allele.name) )
#      class(retval)  <- "allele.count"
      attr(retval,"allele") <- allele.name
      attr(retval,"locus")  <- attr(x,"locus")
      return(retval)
    }
  else
    {
      retval  <- sapply( allele.name, function(y) allele.count(x,y))
      if(any==TRUE && is.matrix(retval)  )
      retval  <- apply(retval,1,sum,na.rm=na.rm)
      if(na.rm) retval[is.na(retval)]  <- 0
#      class(retval)  <- "allele.count"
      attr(retval,"locus")  <- attr(x,"locus")
      return(retval)
    }

}


#print.allele.count  <- function(x,...)
#  { 
#    if(!is.null(attr(x,"locus")))
#        print(attr(x,"locus"))
#    
#    if(is.null(attr(x,"allele")))
#      cat("Allele Counts:\n")
#    else
#      cat("Allele Count (", attr(x,"allele"), " allele):\n", sep="")
#    val  <- x
#    attr(val,"class")  <- NULL
#    attr(val,"allele")  <- NULL
#    print(val)
#    invisible(x)
#  }

###
### Check for the presence of alleles for each individual
###
### By default, return a matrix containing indicators for all possible
### allele values except the last.
###
#
#allele.ind  <-  function(x,allele)
#  {
##    if(missing(allele))
##      stop("Alleles to test must be specified")
##    if(length(allele)==1)
#      retval  <- allele.count(x,allele) > 0
##    else
##      retval  <- apply(allele.count(x,allele) ,1,sum) > 0
#
#      if(missing(allele))
#          allele  <-  colnames(retval)
#      attr(retval,"allele")  <- allele
#      attr(retval,"locus")  <- attr(x,"locus")
#      class(retval)  <-  "allele.ind"
#      return(retval)
#  }
    
#print.allele.ind  <- function(x,...)
#  {
#    if(!is.null(attr(x,"locus")))
#      print(attr(x,"locus"))
#    
#    cat("Indicator(s) for allele(s):", attr(x,"allele"), "\n")
#    attr(x,"locus")  <-  attr(x,"class")  <- attr(x,"allele")  <-  NULL
#    NextMethod("print",x)
#  }

###
### Methods for creating subsets based on a genotype
###

homozygote  <- function (x,allele.name,...) 
  UseMethod("homozygote")

homozygote.genotype  <-  function(x,allele.name,...)
  {
    a1  <- allele(x,1)
    a2  <- allele(x,2)
    if(missing(allele.name))
      retval  <- ifelse( is.na(a1) | is.na(a2), NA, a1==a2 )
    else
      retval  <- ifelse( is.na(a1) | is.na(a2), NA,
                         a1==allele.name & a2==allele.name )
    attr(retval,"locus")  <-  attr(x,"locus")
#    class(retval)  <-  "homozygote"
    return(retval)
  }

#print.homozygote  <- function(x,...)
#  {
#    if(!is.null(attr(x,"locus")))
#      print(attr(x,"locus"))
#    
#    cat("Homozygote Indicators:\n")
#    attr(x,"locus")  <-  attr(x,"class")  <- attr(x,"allele")  <-  NULL
#    NextMethod("print",x)
#  }
    

heterozygote  <- function (x,allele.name,...) 
  UseMethod("heterozygote")

heterozygote.genotype  <-  function(x,allele.name,...)
  {
  {
    a1  <- allele(x,1)
    a2  <- allele(x,2)
    if(missing(allele.name))
      retval  <- ifelse( is.na(a1) | is.na(a2), NA, !a1==a2 )
    else
      retval  <- ( (a1==allele.name) + (a2==allele.name) ) == 1
    attr(retval,"locus")  <-  attr(x,"locus")
#    class(retval)  <-  "homozygote"
    return(retval)
  }
  }

#print.heterozygote  <- function(x,...)
#  {
#    if(!is.null(attr(x,"locus")))
#      print(attr(x,"locus"))
#    
#    cat("Heterozygote Indicators:\n")
#    attr(x,"locus")  <-  attr(x,"class")  <- attr(x,"allele")  <-  NULL
#    NextMethod("print",x)
#  }

carrier <- function (x,allele.name,...) 
  UseMethod("carrier")

carrier.genotype  <-  function(x, allele.name=allele.names(x),
                                   any=!missing(allele), na.rm=FALSE, ...)
{
  retval  <- allele.count(x,allele.name=allele.name,any=any,na.rm=na.rm) > 0
  
  attr(retval,"allele")  <- retval$allele
  attr(retval,"locus")  <-  attr(x,"locus")
#  class(retval)  <- "carrier"
  return(retval)
}


#print.carrier  <- function(x,...)
#  {
#    if(!is.null(attr(x,"locus")))
#      print(attr(x,"locus"))
#    
#    cat("Carrier Indicator(s) for allele(s):", attr(x,"allele"), "\n")
#    attr(x,"locus")  <-  attr(x,"class")  <- attr(x,"allele")  <-  NULL
#    NextMethod("print",unclass(x))
#  }


###
###
###

allele.names<- function(x)
  {
    retval  <- attr(x,"allele.names")
    if(is.null(retval))
      retval  <- x$allele.names
    return(retval)
  }

###
### Subset method
###

"[.genotype"  <-  function(x, i, drop=FALSE)
  {
    retval  <- NextMethod("[")

    # force "NA" not to be a factor level
    ll  <- levels(retval)  <-  na.omit(levels(retval))
    
    class(retval)  <-  c("genotype","factor")

    if(drop)
      alleles <- unique( unlist(strsplit(ll, "/") ) )
    else
      alleles <- attr(x, "allele.names")
    
    attr(retval,"allele.names")  <- alleles
    attr(retval,"allele.map")  <- do.call("rbind", strsplit(ll, "/"))
    attr(retval,"locus")  <- attr(x,"locus")
    attr(retval,"label")  <-  attr(x,"label")
    return(retval)
  }

"[.haplotype"  <-  function(x, i, drop=FALSE)
  {
    retval  <- NextMethod("[")
    class(retval) <- c("haplotype","genotype","factor")
    retval
  }

###
### Subset Assigment method
###

"[<-.genotype"  <-  function(x, i, value)
  {
    if(!is.genotype(value) && !is.na(value))
      stop("Assigned value must be of class genotype.")

    lx <- levels(x)
    lv <- levels(value)
    ax <- allele.names(x)
    av <- allele.names(value)

    m  <- is.na(match(av,ax) )
    if( any( m  )  )
       warning(paste("Adding new allele name(s):", av[m] ))
       
    la <- unique(c(lx,lv))
    aa <- unique(c(ax,av))

    cx <- class(x)
    nas <- is.na(x)

    data  <-  match(levels(value)[value],la)
    
    class(x) <- NULL
    x[i] <- data
    attr(x, "levels") <- la
    map  <- attr(x, "allele.map")  <- do.call("rbind", strsplit(la, "/"))
    attr(x, "allele.names")  <- aa
    class(x) <- cx
    x
  }

"[<-.haplotype"  <-  function(x, i, value)
  {
    if(!is.haplotype(value))
      stop("Assigned value must be of class haplotype.")
    NextMethod("[<-")
  }
