/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.graph;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.Tree;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphUtil {
    public static <V, E> void addVertices(Graph<V, E> graph, Collection<V> vertices) {
        for (V v : vertices) {
            graph.addVertex(v);
        }
    }

    public static <V, E> void copyGraph(Graph<V, E> source, Graph<V, E> target) {
        GraphUtil.addVertices(target, source.getVertices());
        for (Object e : source.getEdges()) {
            target.addEdge(e, (EdgeType)((Object)source.getIncidentVertices(e)), source.getEdgeType(e));
        }
    }

    public static <V, E> void copyTree(Tree<V, E> source, Tree<V, E> target) {
        target.addVertex(source.getRoot());
        LinkedList toAdd = new LinkedList(source.getChildEdges(source.getRoot()));
        while (!toAdd.isEmpty()) {
            Object e = toAdd.removeFirst();
            target.addEdge(e, source.getSource(e), source.getDest(e));
            toAdd.addAll(source.getChildEdges(source.getDest(e)));
        }
    }

    public static <V, E> boolean isDescendant(Tree<V, E> t, V v, V w) {
        if (v.equals(w)) {
            return true;
        }
        for (Object e : t.getOutEdges(v)) {
            if (!GraphUtil.isDescendant(t, t.getDest(e), w)) continue;
            return true;
        }
        return false;
    }

    public static <V, E> boolean isWeaklyConnected(Hypergraph<V, E> graph) {
        if (graph.getVertexCount() == 0) {
            return true;
        }
        HashSet visited = new HashSet();
        LinkedList<V> fringe = new LinkedList<V>();
        fringe.add(graph.getVertices().iterator().next());
        while (!fringe.isEmpty()) {
            Object v = fringe.removeFirst();
            if (!visited.contains(v)) {
                visited.add(v);
                fringe.addAll(graph.getNeighbors(v));
            }
            if (visited.size() != graph.getVertexCount()) continue;
            return true;
        }
        return false;
    }

    public static <V, E> boolean areVerticesWeaklyConnected(Hypergraph<V, E> studyGraph, V first, V second) {
        HashSet visited = new HashSet();
        LinkedList<V> fringe = new LinkedList<V>();
        fringe.add(first);
        while (!fringe.isEmpty()) {
            Object v = fringe.removeFirst();
            if (v.equals(second)) {
                return true;
            }
            visited.add(v);
            HashSet<V> neighbors = new HashSet<V>(studyGraph.getNeighbors(v));
            neighbors.removeAll(visited);
            neighbors.removeAll(fringe);
            fringe.addAll(neighbors);
        }
        return false;
    }

    public static <V, E> boolean isSimpleCycle(UndirectedGraph<V, E> graph) {
        if (graph.getVertexCount() < 3 || graph.getEdgeCount() < graph.getVertexCount()) {
            return false;
        }
        Object v = graph.getVertices().iterator().next();
        HashSet visited = new HashSet();
        visited.add(v);
        while (graph.getNeighborCount(v) == 2 && !visited.containsAll(graph.getNeighbors(v))) {
            Iterator iterator = graph.getNeighbors(v).iterator();
            Object v1 = iterator.next();
            Object v2 = iterator.next();
            if (!visited.contains(v1)) {
                v = v1;
                visited.add(v1);
                continue;
            }
            v = v2;
            visited.add(v2);
        }
        return visited.containsAll(graph.getVertices());
    }

    public static <V, E> V findCommonAncestor(Tree<V, E> tree, V u, V v) {
        while (tree.getDepth(u) > tree.getDepth(v)) {
            u = tree.getParent(u);
        }
        while (tree.getDepth(v) > tree.getDepth(u)) {
            v = tree.getParent(v);
        }
        while (!u.equals(v)) {
            v = tree.getParent(v);
            u = tree.getParent(u);
        }
        return v;
    }

    public static <V, E> List<V> findPath(Tree<V, E> tree, V u, V v) {
        LinkedList<V> path = new LinkedList<V>();
        while (tree.getDepth(u) > tree.getDepth(v)) {
            path.add(u);
            u = tree.getParent(u);
        }
        int idx = path.size();
        while (tree.getDepth(v) > tree.getDepth(u)) {
            path.add(idx, v);
            v = tree.getParent(v);
        }
        while (!u.equals(v)) {
            path.add(idx, v);
            path.add(idx, u);
            ++idx;
            v = tree.getParent(v);
            u = tree.getParent(u);
        }
        path.add(idx, u);
        return path;
    }
}

