% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini_chat.R
\name{gemini_chat}
\alias{gemini_chat}
\title{Multi-turn conversations (chat)}
\usage{
gemini_chat(
  prompt,
  history = list(),
  model = "2.0-flash",
  temperature = 1,
  maxOutputTokens = 8192,
  topK = 40,
  topP = 0.95,
  seed = 1234
)
}
\arguments{
\item{prompt}{The prompt to generate text from}

\item{history}{history object to keep track of the conversation}

\item{model}{The model to use. Options are "2.0-flash", "2.0-flash-lite", "2.5-pro-exp-03-25". Default is '2.0-flash'
see https://ai.google.dev/gemini-api/docs/models/gemini}

\item{temperature}{The temperature to use. Default is 1 value should be between 0 and 2
see https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters}

\item{maxOutputTokens}{The maximum number of tokens to generate.
Default is 8192 and 100 tokens correspond to roughly 60-80 words.}

\item{topK}{The top-k value to use. Default is 40 value should be between 0 and 100
see https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters}

\item{topP}{The top-p value to use. Default is 0.95 value should be between 0 and 1
see https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters}

\item{seed}{The seed to use. Default is 1234 value should be integer
see https://ai.google.dev/gemini-api/docs/models/generative-models#model-parameters}
}
\value{
Generated text
}
\description{
Generate text from text with Gemini
}
\examples{
\dontrun{
library(gemini.R)
setAPI("YOUR_API_KEY")

chats <- gemini_chat("Pretend you're a snowman and stay in character for each")
print(chats$outputs)

chats <- gemini_chat("What's your favorite season of the year?", chats$history)
print(chats$outputs)

chats <- gemini_chat("How do you think about summer?", chats$history)
print(chats$outputs)
}
}
\seealso{
https://ai.google.dev/docs/gemini_api_overview#chat
}
