% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_image.R
\name{gen_image}
\alias{gen_image}
\title{Generate and save image using Gemini}
\usage{
gen_image(
  prompt,
  filename = "gemini_image.png",
  overwrite = TRUE,
  model = "2.0-flash-exp-image-generation",
  temperature = 1,
  seed = 1234
)
}
\arguments{
\item{prompt}{The prompt to generate an image from}

\item{filename}{The filename to save the image to. Default is "gemini_image.png"}

\item{overwrite}{Logical, whether to overwrite existing file. Default is TRUE}

\item{model}{The model to use. Default is "2.0-flash-exp-image-generation"}

\item{temperature}{The temperature to use. Default is 1}

\item{seed}{The seed to use. Default is 1234}
}
\value{
The path to the saved file
}
\description{
Generate an image using Gemini's image generation capabilities and save it to a file
}
\examples{
\dontrun{
library(gemini.R)
setAPI("YOUR_API_KEY")
gen_image("Create an image of a cat wearing sunglasses")
}
}
