% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateData.R
\name{generateData}
\alias{generateData}
\title{Generate Data for Simulation}
\usage{
generateData(n_sub, n_obs, p, beta0, rho, type = "ar", dis = "normal", ka)
}
\arguments{
\item{n_sub}{Integer, the number of subjects.}

\item{n_obs}{Integer or numeric vector, the number of observations per subject.}

\item{p}{Integer, the number of predictors.}

\item{beta0}{Numeric vector, initial coefficients for the first few predictors.}

\item{rho}{Numeric, the correlation coefficient used in generating correlated errors.}

\item{type}{Character, the type of correlation structure (default is autoregressive).}

\item{dis}{Character, the distribution of errors ("normal" or "t").}

\item{ka}{1 for heterogeneous errors and 0 for homogeneous errors.}
}
\value{
A list containing two elements: `X`, the matrix of predictors, and `y`, the response vector.
}
\description{
This function generates simulated data including the predictor matrix `X` and the response vector `y`,
based on the specified parameters. The function allows for the simulation of data under different settings
of correlation, distribution, and the number of observations and subjects.
}
\examples{
sim_data <- generateData(n_sub = 100, n_obs = rep(10, 100),  p = 200,
                         beta0 = rep(1,7), rho = 0.6, type = "ar",
                          dis = "normal", ka = 1)
}
