% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srsgd.R
\name{srsgd}
\alias{srsgd}
\title{spatial rough set-based geographical detector(SRSGD) model}
\usage{
srsgd(formula, data, wt = NULL, type = "factor", alpha = 0.95)
}
\arguments{
\item{formula}{A formula of spatial rough set-based geographical detector model.}

\item{data}{A \code{data.frame}, \code{tibble} or \code{sf} object of observation data.}

\item{wt}{Spatial adjacency matrix. If \code{data} is a \code{sf} polygon object, the queen
adjacency matrix is used when no \code{wt} object is provided. In other cases, you must
provide a \code{wt} object.}

\item{type}{(optional) The type of geographical detector, which must be one of
\code{factor}(default), \code{interaction} and \code{ecological}.}

\item{alpha}{(optional) Specifies the size of the alpha (confidence level). Default is \code{0.95}.}
}
\value{
A list.
\describe{
\item{\code{factor}}{the result of spatial rough set-based factor detector}
\item{\code{interaction}}{the result of spatial rough set-based interaction detector}
\item{\code{ecological}}{the result of spatial rough set-based ecological detector}
}
}
\description{
spatial rough set-based geographical detector(SRSGD) model
}
\note{
The Spatial Rough Set-based Geographical Detector Model (SRSGD) conducts spatial
hierarchical heterogeneity analysis utilizing a geographical detector for data
where \emph{the dependent variable} is \emph{discrete}. Given the complementary relationship
between SRSGD and the native version of geographical detector, I strive to maintain
consistency with \code{gd()} function when establishing \code{srsgd()} function. This implies
that all input variable data in srsgd must \emph{be discretized prior to use}.
}
\examples{
data('srs_table')
data('srs_wt')
srsgd(d ~ a1 + a2 + a3, data = srs_table, wt = srs_wt,
      type = c('factor','interaction','ecological'))

}
\references{
Bai, H., Li, D., Ge, Y., Wang, J., & Cao, F. (2022). Spatial rough set-based
geographical detectors for nominal target variables. Information Sciences, 586, 525–539.
https://doi.org/10.1016/j.ins.2021.12.019
}
\author{
Wenbo Lv \email{lyu.geosocial@gmail.com}
}
