% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fonts.R
\name{addGFontHtmlDependency}
\alias{addGFontHtmlDependency}
\title{Use a font in Shiny or Markdown}
\usage{
addGFontHtmlDependency(family = "Open Sans", subset = c("latin", "latin-ext"))
}
\arguments{
\item{family}{family name of a 'Google Fonts', for example, "Open Sans", "Roboto",
"Fira Code" or "Fira Sans Condensed". Complete list is available with the
following command:

\if{html}{\out{<div class="sourceCode">}}\preformatted{gfonts::get_all_fonts()$family |>
  unlist() |>
  unique() |>
  sort()
}\if{html}{\out{</div>}}}

\item{subset}{font subset, a character vector, it defaults to only "latin" and
"latin-ext" and can contains values such as "greek", "emoji", "chinese-traditional",

Run the following code to get a complete list:

\if{html}{\out{<div class="sourceCode">}}\preformatted{gfonts::get_all_fonts()$subsets |> unlist() |> unique() |> sort()
}\if{html}{\out{</div>}}}
}
\value{
an HTML object
}
\description{
Add an empty HTML element attached
to an 'HTML Dependency' containing
the css and the font files so that the font is available
in the HTML page. Multiple families are supported.

The htmlDependency is defined with function \code{\link[=gfontHtmlDependency]{gfontHtmlDependency()}}.
}
\details{
It allows users to use fonts from 'Google Fonts' in an HTML page generated by 'shiny' or 'R Markdown'.
At the first request, the font files will be downloaded and stored in a cache on the
user's machine, thus avoiding many useless downloads or allowing to work with
these fonts afterwards without an Internet connection, in a docker image for example.
See \code{\link[=fonts_cache_dir]{fonts_cache_dir()}}.

The server delivering the font files should not be too busy. That's
why a one second pause is added after each download to respect the server's
limits. This time can be set with the option \code{GFONTS_DOWNLOAD_SLEEPTIME} which
must be a number of seconds.
}
\examples{
if (require("curl") && curl::has_internet()) {
  dummy_setup()
  addGFontHtmlDependency(family = "Open Sans")
}
}
\seealso{
Other functions for font management: 
\code{\link{fonts_cache_dir}()},
\code{\link{gfontHtmlDependency}()},
\code{\link{install_gfont_script}()},
\code{\link{installed_gfonts}()},
\code{\link{liberationsansHtmlDependency}()},
\code{\link{register_gfont}()},
\code{\link{register_liberationsans}()}
}
\concept{functions for font management}
