% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretty-gbm-tree.r
\name{pretty_gbm_tree}
\alias{pretty_gbm_tree}
\title{Print gbm tree components}
\usage{
pretty_gbm_tree(gbm_fit_obj, tree_index = 1)
}
\arguments{
\item{gbm_fit_obj}{a \code{GBMFit} object initially fit using
\code{\link{gbmt}}.}

\item{tree_index}{the index of the tree component to extract from \code{gbm_fit_obj}
and display.}
}
\value{
\code{pretty_gbm_tree} returns a data frame. Each row corresponds to
a node in the tree. Columns indicate \item{SplitVar}{index of which variable
is used to split. -1 indicates a terminal node.} \item{SplitCodePred}{if the
split variable is continuous then this component is the split point. If the
split variable is categorical then this component contains the index of
\code{gbm_fit_obj$c.split} that describes the categorical split. If the node is a
terminal node then this is the prediction.} \item{LeftNode}{the index of the
row corresponding to the left node.} \item{RightNode}{the index of the row
corresponding to the right node.} \item{ErrorReduction}{the reduction in the
loss function as a result of splitting this node.} \item{Weight}{the total
weight of observations in the node. If weights are all equal to 1 then this
is the number of observations in the node.}
}
\description{
\code{GBMFit} stores the collection of trees used to construct the model in a
compact matrix structure. This function extracts the information from a
single tree and displays it in a slightly more readable form. This function
is mostly for debugging purposes and to satisfy some users' curiosity.
}
\seealso{
\code{\link{gbm}}, \code{\link{gbmt}}
}
\author{
James Hickey, Greg Ridgeway \email{gregridgeway@gmail.com}
}
\keyword{print}
