% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbm-perf.r
\name{gbm.perf}
\alias{gbm.perf}
\title{GBMT Performance}
\usage{
gbm.perf(
  object,
  plot.it = TRUE,
  oobag.curve = FALSE,
  overlay = TRUE,
  method,
  main = ""
)
}
\arguments{
\item{object}{a \code{GBMFit} object created from an initial
call to \code{\link{gbmt}} or \code{\link{gbm}}.}

\item{plot.it}{an indicator of whether or not to plot the
performance measures. Setting \code{plot.it=TRUE} creates two
plots. The first plot plots the train error (in black)
and the validation error (in red) versus the iteration
number. The scale of the error measurement, shown on the left
vertical axis, depends on the \code{distribution} argument used in
the initial call.}

\item{oobag.curve}{indicates whether to plot the out-of-bag
performance measures in a second plot.}

\item{overlay}{if TRUE and oobag.curve=TRUE then a right y-axis is
added to the training and test error plot and the estimated
cumulative improvement in the loss function is plotted versus the
iteration number.}

\item{method}{indicate the method used to estimate the optimal
number of boosting iterations. \code{method="OOB"} computes the
out-of-bag estimate and \code{method="test"} uses the test (or
validation) dataset to compute an out-of-sample
estimate. \code{method="cv"} extracts the optimal number of
iterations using cross-validation if \code{gbm} was called with
\code{cv.folds}>1.}

\item{main}{the main title for the plot. Defaults to \code{main =
""}.}
}
\value{
\code{gbm.perf} returns the estimated optimal number of iterations.
The method of computation depends on the \code{method} argument.
}
\description{
Estimates optimal number of boosting iterations given a
\code{GBMFit} object and optionally plots various performance
measures.
}
\seealso{
\code{\link{gbmt}} \code{\link{gbmt_performance}}
\code{\link{plot.GBMTPerformance}}
}
\keyword{nonlinear}
\keyword{nonparametric}
\keyword{survival}
\keyword{tree}
