% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lrr_plot.R
\name{lrr_plot}
\alias{lrr_plot}
\title{Prepare log relative risk values for plotting with a diverging color palette}
\usage{
lrr_plot(
  input,
  cols,
  midpoint = 0,
  lower_lrr = NULL,
  upper_lrr = NULL,
  digits = 1
)
}
\arguments{
\item{input}{An object of class 'rrs' from the \code{\link{rrs}} or \code{\link{lotrrs}} function.}

\item{midpoint}{Numeric. The value to center the diverging color palette.}

\item{lower_lrr}{Numeric. The lower value to concatenate the color key. The default (NULL) uses the minimum value from \code{input}.}

\item{upper_lrr}{Numeric. The upper value to concatenate the color key. The default (NULL) uses the maximum value from \code{input}.}

\item{digits}{Integer. The number of significant digits for the labels using the \code{round} function (default is 1).}

\item{plot_cols}{Character string of length three (3) specifying the colors for plotting: 1) numerator, 2) insignificant, and 3) denominator from the \code{\link{rrs}} or \code{\link{lotrrs}}  function.}
}
\value{
An object of class 'list'. This is a named list with the following components:

\describe{
\item{\code{v}}{An object of class 'SpatRaster' for the estimated gating surface.}
\item{\code{cols}}{An object of class 'vector', returns diverging color palette values.}
\item{\code{breaks}}{An object of class 'vector', returns diverging color palette breaks.}
\item{\code{at}}{An object of class 'vector', returns legend breaks.}
\item{\code{labels}}{An object of class 'vector', returns legend labels.}
}
}
\description{
Internal function to convert an object of class 'im' to values readable by \code{\link[fields]{image.plot}} function within the \code{\link{rrs}} and \code{\link{lotrrs}} functions.
}
\keyword{internal}
