% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gapmap.R
\name{gapmap}
\alias{gapmap}
\title{Function to draw a gapped cluster heatmap}
\usage{
gapmap(m, d_row, d_col, mode = c("quantitative", "threshold"),
  mapping = c("exponential", "linear"), ratio = 0.2, scale = 0.5,
  threshold = 0, row_threshold = NULL, col_threshold = NULL,
  rotate_label = TRUE, verbose = FALSE, left = "dendrogram",
  top = "dendrogram", right = "label", bottom = "label",
  col = c("#053061", "#2166AC", "#4393C3", "#92C5DE", "#D1E5F0", "#F7F7F7",
  "#FDDBC7", "#F4A582", "#D6604D", "#B2182B", "#67001F"), h_ratio = c(0.2,
  0.7, 0.1), v_ratio = c(0.2, 0.7, 0.1), label_size = 5,
  show_legend = FALSE, ...)
}
\arguments{
\item{m}{matrix}

\item{d_row}{a dendrogram class object for rows}

\item{d_col}{a dendrogram class object for columns}

\item{mode}{gap mode, either "threshold" or "quantitative"}

\item{mapping}{in case of quantitative mode, either "linear" or "exponential" mapping}

\item{ratio}{the percentage of width allocated for the sum of gaps.}

\item{scale}{the sclae log base for the exponential mapping}

\item{threshold}{the height at which the dendrogram is cut to infer clusters}

\item{row_threshold}{the height at which the row dendrogram is cut}

\item{col_threshold}{the height at which the column dendrogram is cut}

\item{rotate_label}{a logical to rotate column labels or not}

\item{verbose}{logical for whether in verbose mode or not}

\item{left}{a character indicating "label" or "dendrogram" for composition}

\item{top}{a character indicating "label" or "dendrogram" for composition}

\item{right}{a character indicating "label" or "dendrogram" for composition}

\item{bottom}{a character indicating "label" or "dendrogram" for composition}

\item{col}{colors used for heatmap}

\item{h_ratio}{a vector to set the horizontal ratio of the grid. It should add up to 1. top, center, bottom.}

\item{v_ratio}{a vector to set the vertical ratio of the grid. It should add up to 1. left, center, right.}

\item{label_size}{a numeric to set the label text size}

\item{show_legend}{a logical to set whether to show a legend or not}

\item{...}{ignored}
}
\value{
a ggplot object
}
\description{
This function draws a gapped cluster heatmap using the ggplot2 package. The input for the
function is the a matrix, two dendrograms, and parameters for gaps.
}
\examples{
set.seed(1234)
#generate sample data
x <- rnorm(10, mean=rep(1:5, each=2), sd=0.4)
y <- rnorm(10, mean=rep(c(1,2), each=5), sd=0.4)
dataFrame <- data.frame(x=x, y=y, row.names=c(1:10))
#calculate distance matrix. default is Euclidean distance
distxy <- dist(dataFrame)
#perform hierarchical clustering. default is complete linkage.
hc <- hclust(distxy)
dend <- as.dendrogram(hc)
#make a cluster heatmap plot
gapmap(m = as.matrix(distxy), d_row= rev(dend), d_col=dend)

}

