% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hap.R
\name{hap}
\alias{hap}
\title{Haplotype reconstruction}
\usage{
hap(
  id,
  data,
  nloci,
  loci = rep(2, nloci),
  names = paste("loci", 1:nloci, sep = ""),
  control = hap.control()
)
}
\arguments{
\item{id}{a column of subject id.}

\item{data}{genotype table.}

\item{nloci}{number of loci.}

\item{loci}{number of alleles at all loci.}

\item{names}{locus names.}

\item{control}{is a call to hap.control().}
}
\value{
The returned value is a list containing:
\describe{
\item{l1}{log-likelihood assuming linkage disequilibrium}
\item{converge}{convergence status, 0=failed, 1=succeeded}
\item{niter}{number of iterations}
}
}
\description{
Haplotype reconstruction using sorting and trimming algorithms.
}
\details{
The package can hanlde much larger number of multiallelic loci. 
For large sample size with relatively small number of multiallelic
loci, genecounting should be used.
}
\note{
adapted from hap.
}
\examples{
\dontrun{
require(gap.datasets)
# 4 SNP example, to generate hap.out and assign.out alone
data(fsnps)
hap(id=fsnps[,1],data=fsnps[,3:10],nloci=4)
dir()

# to generate results of imputations
control <- hap.control(ss=1,mi=5,hapfile="h",assignfile="a")
hap(id=fsnps[,1],data=fsnps[,3:10],nloci=4,control=control)
dir()
}

}
\references{
Clayton DG (2001) SNPHAP. https://github.com/chr1swallace/snphap.

Zhao JH and W Qian (2003) Association analysis of unrelated individuals
using polymorphic genetic markers. RSS 2003, Hassalt, Belgium

Zhao JH (2004). 2LD, GENECOUNTING and HAP: Computer programs for linkage
disequilibrium analysis. Bioinformatics 20: 1325-1326
}
\seealso{
\code{\link[gap]{genecounting}}
}
\keyword{models}
