# multivariate meta-analysis

v2m <- function(v)
{
  m <- matrix(0,3,3)
  m[upper.tri(m,diag=TRUE)] <- v
  m[lower.tri(m)] <- t(m)[lower.tri(m)]
  m
}
d <- c(
0.437854,0.083030,0.000000,0.112287,0.00126524,-0.00119897,0.00454957,-4.21798e-05,-0.00332543,0.0033521,
0.436604,0.074180,0.063408,0.076599,0.000575098,-0.000517877,0.00159733,-3.94899e-05,-0.00106087,0.00108936,
0.449853,0.010076,0.000000,0.186246,0.0020538,-0.00208027,0.00806807,2.17958e-05,-0.00594376,0.00592807,
0.369358,0.112810,0.000000,0.069619,0.00197329,-0.00202428,0.00781155,9.97701e-05,-0.00576187,0.00563101,
0.449819,0.044273,0.011836,0.127123,0.000745896,-0.000696385,0.00257303,-3.7447e-05,-0.00186571,0.00190461,
0.486963,0.036626,0.001735,0.165122,0.000352309,-0.00021861,0.000840766,-0.000124913,-0.000618997,0.000752675)
d <- matrix(d,6,10,byrow=TRUE)
V <- list()
for (i in 1:6) V[[i]] <- v2m(d[i,-c(1:4)])
library(mvmeta) 
mv <- mvmeta(d[,2:4],V)
detach(package:mvmeta)
library(gap)
h2 <- h2GE(coef(mv),vcov(mv))
with(h2,h2l(P=0.497286,h2=h2G,se=sqrt(Varh2G))) # main
with(h2,h2l(P=0.497286,h2=h2GE,se=sqrt(Varh2GE))) # interaction
with(h2,h2l(P=0.497286,h2=h2sGGE,se=sqrt(Varh2sGGE))) # main+interaction

