      SUBROUTINE POOLFD(NGROUP,NFAM,NLINK,XOBS,MAXGRP)
C
C TWO SUBROUTINES TO POOL AND UNPOOL ADULT AND YOUNG SIBS IN THE
C PATHMIX FAMILY DATA COMMON BLOCK (FAMDAT)
C
C  IN GENERAL, COMMON /FAMDAT/ CONTAINS:
C     NFAM    -- NUMBER OF FAMILIES
C     NLINK() -- NUMBER OF OBS. IN EACH GROUP (PF...IC FOR EACH FAMILY)
C     XOBS()  -- THE DATA
C
C THIS SUBROUTINE REARRANGES XOBS() SO THAT YOUNG AND ADULT SIB DATA
C ARE COMBINED.  WHERE THE DATA IS ORIGINALLY ORDERED -PC-IC-PCA-ICA,
C THIS POOLING SUBROUTINE REORDERS IT TO -PC-PCA-IC-ICA. THE INTEGRITY
C OF MATCHED PHENOTYPE-INDEX PAIRS IS PRESERVED.  THE ORIGINAL ORDER
C IS RESTORED IN THE UNPOOLING SUBROUTINE.
C
C CORRESPONDINGLY, NLINK() IS UPDATED TO REFLECT THE REVISED STATUS
C OF GROUPS 5 AND 6 (PC AND IC).  NLINK 6 AND 7 ARE RETAINED AS THEY
C ARE NEEDED IN THE UNPOOLING.  THEREFORE IT IS IMPERATIVE THAT ONLY
C 6 GROUPS BE REFERENCED (AND NOT THE LAST 2) WHILE THE DATA IS IN
C THE POOLED STATE.
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      REAL        XOBS
      DIMENSION   NLINK(MAXGRP,*), XOBS(*)
C
      DIMENSION   SIBTMP(30), NEWSEQ(6,2), LINK(7)
C
      DATA NEWSEQ /1,4,2,5,3,6,
     +             1,3,5,2,4,6/
C
C FIRST THE POOLING...
C
      IF (NGROUP .NE. 8) STOP 'POOLFD: DATA INCONSISTENT'
C
      IOBS = 0
      DO 190 IFAM=1,NFAM
C
C       SKIP PAST PF, IF, PM AND IM FOR CURRENT FAMILY:
         DO 110 I=1,4
            IOBS = IOBS + NLINK(I,IFAM)
110      CONTINUE
C
C       GET POINTERS INTO XOBS(), PARTITIONING IT INTO 6 PARTS:
C       - MATCHED PC - REM PC - IC - MATCHED PCA - REM PCA - ICA -
         LINK(1) = IOBS
         LINK(2) = LINK(1) + NLINK(6,IFAM)
         IOBS = IOBS + NLINK(5,IFAM)
         LINK(3) = IOBS
         IOBS = IOBS + NLINK(6,IFAM)
         LINK(4) = IOBS
         LINK(5) = LINK(4) + NLINK(8,IFAM)
         IOBS = IOBS + NLINK(7,IFAM)
         LINK(6) = IOBS
         IOBS = IOBS + NLINK(8,IFAM)
         LINK(7) = IOBS
C
C       COPY SIB DATA TO TEMP ARRAY, EXTRACTING 6 PARTS AS FOLLOWS:
C       MATCHED PC, MATCHED PCA, REMAINING PC, REMAINING PCA, IC, ICA
         J = 0
         DO 130 IPART=1,6
            L1 = LINK( NEWSEQ(IPART,1)   ) + 1
            L2 = LINK( NEWSEQ(IPART,1)+1 )
            DO 120 I=L1,L2
               J = J + 1
               SIBTMP(J) = XOBS(I)
120         CONTINUE
130      CONTINUE
C
C       UPDATE POOLED PC AND IC COUNTS (MUST SAVE 7&8 FOR UNPOOLING):
         NLINK(5,IFAM) = NLINK(5,IFAM) + NLINK(7,IFAM)
         NLINK(6,IFAM) = NLINK(6,IFAM) + NLINK(8,IFAM)
C
C       UPDATE SIB DATA FOR THIS FAMILY TO NEW ORDER:
         DO 140 I=1,J
            XOBS( LINK(1) + I ) = SIBTMP(I)
140      CONTINUE
C
190   CONTINUE
C
      NGROUP = 6
      RETURN
C
C NOW THE UNPOOLING...
C
      ENTRY UNPLFD(NGROUP)
C
      IF (NGROUP.NE.6) STOP 'UNPLFD: NGROUP INVALID'
C
      IOBS = 0
      DO 290 IFAM=1,NFAM
C
C       SKIP PAST PF, IF, PM AND IM FOR CURRENT FAMILY:
         DO 210 I=1,4
            IOBS = IOBS + NLINK(I,IFAM)
210      CONTINUE
C
C       GET POINTERS INTO XOBS(), PARTITIONING IT INTO 6 PARTS:
C       - MATCHED PC - MATCHED PCA - REM PC - REM PCA - IC - ICA -
         LINK(1) = IOBS
         LINK(2) = LINK(1) + NLINK(6,IFAM) - NLINK(8,IFAM)
         LINK(3) = LINK(1) + NLINK(6,IFAM)
         LINK(4) = LINK(1) + NLINK(5,IFAM) -NLINK(7,IFAM)+NLINK(8,IFAM)
         IOBS = IOBS + NLINK(5,IFAM)
         LINK(5) = IOBS
         LINK(6) = LINK(5) + NLINK(6,IFAM) - NLINK(8,IFAM)
         IOBS = IOBS + NLINK(6,IFAM)
         LINK(7) = IOBS
C
C       COPY SIB DATA TO TEMP ARRAY, EXTRACTING 6 PARTS AS FOLLOWS:
C       MATCHED PC, REMAINING PC, IC, MATCHED PCA, REMAINING PCA, ICA
         J = 0
         DO 230 IPART=1,6
            L1 = LINK( NEWSEQ(IPART,2)   ) + 1
            L2 = LINK( NEWSEQ(IPART,2)+1 )
            DO 220 I=L1,L2
               J = J + 1
               SIBTMP(J) = XOBS(I)
220         CONTINUE
230      CONTINUE
C
C       RESTORE UNPOOLED PC AND IC COUNTS:
         NLINK(5,IFAM) = NLINK(5,IFAM) - NLINK(7,IFAM)
         NLINK(6,IFAM) = NLINK(6,IFAM) - NLINK(8,IFAM)
C
C       UPDATE THE DATA WITH THE PRE-POOLED ORDER:
         DO 240 I=1,J
            XOBS( LINK(1) + I ) = SIBTMP(I)
240      CONTINUE
C
290   CONTINUE
C
      NGROUP = 8
      RETURN
      END
