      SUBROUTINE OUTPUT3b(NALL,PAR,XALL,ITP,SE,U,COV,NCOV,NC,CC,
     +   IVAR,IVERB,LFNTER,H,NIT,NFE,PTG,IDG,FX,FC,NK,MSG)
C---
C--- WRITES FINAL OUTPUT TO TERSE
C---
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

      CHARACTER   PAR(*)*(*), MSG*(*)
      DIMENSION   XALL(NALL), ITP(NALL), SE(NALL), U(NALL)
      DIMENSION   COV(NCOV,NCOV), CC(NC)

#include "path3.inc"

      CHARACTER   IPAR(NGROUP)*2

      DATA IPAR /'PF','IF','PM','IM','PC','IC'/
C
C INDICATE IF THE LIKELIHOOD FUNCTION IS UNDEFINED AT THE FINAL VALUE
C
      IF (IPD .NE. 0) WRITE (LFNTER,1110) IPD
 1110 FORMAT (/'  ** WARNING:',I6,' SIGMA-MATRICES WERE NOT POSITIVE-',
     + 'DEFINITE IN THE LAST FUNCTION EVALUATION **')
C
C WRITE COVARIANCE MATRIX TO TERSE
C
      IF (IVAR .NE. 0) THEN
         IF (IVAR .EQ. 1) THEN
            WRITE (LFNTER,1200)
            WRITE (LFNTER,1210) ((PAR(I), J=1,ITP(I)), I=1,NALL)
            K = 0
            DO 210 I=1,NALL
               IF (ITP(I) .GT. 0) THEN
                  K = K + 1
                  WRITE (LFNTER,1220) PAR(I), (COV(J,K),J=1,K)
               END IF
210         CONTINUE
         ELSE
            WRITE (LFNTER,1250)
         END IF
      END IF

 1200 FORMAT (/' ','FACTORIZATION OF B-MATRIX HAS SUCCEEDED')
 1210 FORMAT (/' ','COVARIANCE MATRIX',
     +        /3X,(18(4X,A)))
 1220 FORMAT (' ',A3,18F7.3, /(4X,18F7.3))
 1250 FORMAT (/' ','FACTORIZATION OF B-MATRIX HAS FAILED')
C
C WRITE CPU TIME
C
      CALL TIMER(CPUMIN)

      WRITE (LFNTER,1300) CPUMIN
 1300 FORMAT (//' ','OPTIMIZATION TOOK:',F12.2,' MIN. CPU TIME')
C
C WRITE TERMINATION MESSAGE
C
      NMSG = LENSTR(MSG)
      WRITE (LFNTER,1400) IDG, MSG(1:NMSG)
 1400 FORMAT (/' ITERATIVE PROCESS TERMINATED BECAUSE: (IDG =',I2,')',
     +        /10X,'*** ',A,' ***')
C
C WRITE SUMMARY
C
      CALL EJECT(LFNTER)
      WRITE (LFNTER,1500) -PTG, 2.*FX, FC, NK, NIT, NFE

 1500 FORMAT (/' ',29('- '),' SUMMARY OUTPUT ',28(' -'),
     +       //' ','UK-1U =',F16.10,'    -2 LN L =',1PG19.10,
     +             '    FC =',G8.2,
     +             '    NK =',I3,'    NIT =',I4,'    NFE =',I5)
C
C FINAL PARAMETER ESTIMATES
C
      NPARM = NALL - 2*NGROUP
      I1 = NPARM/2

      WRITE (LFNTER,1510) (PAR(I),  I=1,I1)
      WRITE (LFNTER,1520) (XALL(I), I=1,I1)
      WRITE (LFNTER,1530) (U(I),    I=1,I1)
      WRITE (LFNTER,1540) (SE(I),   I=1,I1)

      WRITE (LFNTER,1510) (PAR(I),  I=I1+1,NPARM)
      WRITE (LFNTER,1520) (XALL(I), I=I1+1,NPARM)
      WRITE (LFNTER,1530) (U(I),    I=I1+1,NPARM)
      WRITE (LFNTER,1540) (SE(I),   I=I1+1,NPARM)

      WRITE (LFNTER,1510) (PAR(I),  I=NPARM+1,NALL)
      WRITE (LFNTER,1520) (XALL(I), I=NPARM+1,NALL)
      WRITE (LFNTER,1530) (U(I),    I=NPARM+1,NALL)
      WRITE (LFNTER,1540) (SE(I),   I=NPARM+1,NALL)

 1510 FORMAT(/(' PARAMETER:',12(4X,A3,2X)))
 1520 FORMAT ((' ESTIMATES:',12F9.5))
 1530 FORMAT ((' U-SCORES :',12F9.5))
 1540 FORMAT ((' S.E.     :',12F9.5))
C
C WRITE CORRELATION ESTIMATES TO TERSE FILE
C
      DO 600 I=1,4
         RHO(I,I) = 1.0
600   CONTINUE

      WRITE (LFNTER,1600)
      WRITE (LFNTER,1610) IPAR
      DO 610 I=1,NGROUP
         WRITE (LFNTER,1620) IPAR(I), (RHO(J,I), J=1,I)
610   CONTINUE
      WRITE (LFNTER,1630) RHO(6,5)

 1600 FORMAT(//' ',17X,19X,'CORRELATION ESTIMATES')
 1610 FORMAT (/' ',17X,2X,6(6X,A3,1X))
 1620 FORMAT (/' ',17X,A2,6F10.5)
 1630 FORMAT(//' ',17X,
     +  '     SIBLING PHENOTYPE -VS- SELF-INDEX CORRELATION =',F10.5)
C
C GET VARIANCE COMPONENTS AND STANDARD ERRORS
C
800   CALL VAP(NPARM,XALL,ITP,COV,NCOV,NC,CC,LFNTER,H)
C
C WRITE INDIVIDUAL GOODNESS OF FIT TO PROLIX
C
      IF (IVERB .GT. 2) THEN
         GOFOUT = .TRUE.
         CALL FUN3b(FX,XALL,NALL,CC,NC)
         GOFOUT = .FALSE.
      END IF
      END
