      SUBROUTINE GETFAM(NGROUP,NFAM,NLINK,XOBS,MAXGRP,MAXFAM,MAXOBS,
     +   LFNDAT,IQ)
C
C READS PROCESSED FAMILY DATA FILE OF THE FORM CREATED BY THE
C PATHMIX INPUT ROUTINE (PATHIN)
C
C INPUT:
C     MAXGRP -- MAXIMUM NUMBER OF GROUPS AS DIMENSIONED IN NLINK(,)
C     MAXFAM -- MAXIMUM NUMBER OF FAMILIES AS DIMENSIONED IN NLINK(,)
C     MAXFAM -- MAXIMUM NUMBER OF OBS AS DIMENSIONED IN XOBS()
C
C RETURNED:
C     NGROUP -- NUMBER OF GROUPS
C     NFAM   -- NUMBER OF FAMILIES
C     NLINK()-- NUMBER OF OBS. IN EACH FAMILY BY GROUP
C     XOBS() -- THE DATA
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      REAL        XOBS
      DIMENSION   NLINK(MAXGRP,MAXFAM), XOBS(MAXOBS)
C
      DIMENSION   NN(12)
C
      NFAM = 0
      NOBS = 0
C
C GET NUMBER OF VARIABLES TO READ
C
      READ (LFNDAT,*,END=900) NGROUP
      IF (NGROUP .GT. MAXGRP) THEN
         STOP 'GETFAM: MAX NO. GROUPS EXCEEDED'
      END IF
C
C READ FAMILY RECORDS:
C
100   CONTINUE
C       READ COUNTS OF OBS. FOR THIS FAMILY:
         READ (LFNDAT,*,END=900) (NN(I), I=1,NGROUP)
         IF (NFAM+1 .GT. MAXFAM) THEN
            STOP 'GETFAM: MAXIMUM NUMBER OF FAMILIES EXCEEDED'
         END IF
C
         N = 0
         DO 110 I=1,NGROUP
            N = N + NN(I)
            NLINK(I,NFAM+1) = NN(I)
110      CONTINUE
         IF (NOBS+N .GT. MAXOBS) THEN
            STOP 'GETFAM: MAXIMUM NUMBER OF OBSERVATIONS EXCEEDED'
         END IF
C
C       READ OBSERVATIONS:
         READ (LFNDAT,*) (XOBS(NOBS+I), I=1,N)
         NOBS = NOBS + N
         NFAM = NFAM + 1
      GO TO 100
C
C WRITE A SUMMARY AND RETURN
C
900   WRITE (IQ,1900) NFAM, NOBS
cdec  WRITE (0, 1900) NFAM, NOBS
CHAR  WRITE (*, 1900) NFAM, NOBS
 1900 FORMAT (/' ',I4,' FAMILIES READ',I10,' OBSERVATIONS')
CCC     +            ' (PHENOTYPES AND INDICES)')
C
      IF (NFAM .LE. 0) STOP 'NO DATA'
C
      RETURN
      END
