% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Segment-generics.R, R/Segment-methods.R
\docType{methods}
\name{PerSession}
\alias{PerSession}
\alias{PerSession,ANY-method}
\alias{PerSession,gaMetExpr-method}
\alias{PerSession,formula-method}
\title{PerSession.}
\usage{
PerSession(object, ..., negation)

\S4method{PerSession}{ANY}(object, ..., negation)

\S4method{PerSession}{gaMetExpr}(object, ..., negation)

\S4method{PerSession}{formula}(object, ..., negation)
}
\arguments{
\item{object}{a .gaSegmentFilter or gaMetExpr object to coerce to
session-level. Alternatively, an dimension expression or segment filter to
coerce into a session scoped gaDynSegment.}

\item{...}{Other filters to include in the gaDynSegment.}

\item{negation}{boolean value indicating whether to negate the condition.}
}
\value{
a gaMetExpr, .gaSegmentFilter or gaDynSegment.

  To define a gaDynSegment comprised of a single metric expression,
  wrap the metric expression in an \code{Include} or \code{Exclude} call.
}
\description{
Set the scope of a .gaSegmentFilter or gaMetExpr object to session-level.
}
\section{Methods (by class)}{
\itemize{
\item \code{ANY}: Create a session level segment filter list from the
supplied expressions, interpreted as condition filters.

\item \code{gaMetExpr}: Set the scope of the supplied metric condition to
session-level.

\item \code{formula}: Set the scope of the supplied non-standard-evaluation
metric condition to session-level.
}}

