% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/results.R
\name{create_results_columns}
\alias{create_results_columns}
\title{Create or Delete Results - Columns}
\usage{
create_results_columns(auth, table_id, columns)
}
\arguments{
\item{auth}{Highbond authentication credentials, created from \code{\link{setup_highbond}}}

\item{table_id}{The ID number of the table}

\item{columns}{A data frame with columns to be added}
}
\value{
If creating or updating, a data frame with the new details.
When deleting, JSON response indicating success or failure.
}
\description{
\link[galvanizer]{post_results_records} will upload a data frame with the
correct specification for the fields uploaded. You can use this function to
add columns manually if preferred, especially if a non-standard column type.
}
\details{
When creating columns, the argument will accept a data frame. This
data frame must only have three columns - \code{field_name}, \code{display_name}, and
\code{data_type.} See API for allowable \code{data_type.}

When deleting columns, the argument will accept a data frame. This data
frame must only have one column - \code{field_name}
}
\examples{
\dontrun{
  auth <- setup_highbond(Sys.getenv('highbond_openapi'), 
    Sys.getenv('highbond_org'), 
    Sys.getenv('highbond_datacenter'))
    
  field_name <- c("a", "b", "c", "d", "e", "f", "g")
  display_name <- c("field_one", "field_two", "field_three", 
    "field_four", "field_five", "field_six", "field_seven")
  data_type <- c("character", "numeric", 'logical', 
    'date', 'datetime', 'file', 'digital_signature')
  columns <- data.frame(field_name, display_name, data_type)
  
  table_id <- 12345
  response <- create_results_columns(auth, table_id, columns)
}

}
