% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_querygraph.R
\name{graph_query}
\alias{graph_query}
\alias{querygraph}
\alias{qgraph}
\alias{ancestors}
\alias{subGraph}
\alias{is.triangulated}
\alias{connComp}
\alias{ancestralSet}
\alias{ancestralGraph}
\alias{parents}
\alias{children}
\alias{separates}
\alias{closure}
\alias{adj}
\alias{is.simplicial}
\alias{simplicialNodes}
\alias{is.complete}
\alias{is.decomposition}
\alias{nodes_}
\alias{nodes}
\alias{nodes,igraph-method}
\alias{edges}
\alias{edges_}
\alias{addEdge}
\alias{removeEdge}
\title{Query a graph}
\usage{
querygraph(object, op, set = NULL, set2 = NULL, set3 = NULL)

qgraph(object, op, set = NULL, set2 = NULL, set3 = NULL)

ancestors(set, object)

subGraph(set, object)

is.triangulated(object)

connComp(object)

ancestralSet(set, object)

ancestralGraph(set, object)

parents(set, object)

children(set, object)

separates(set, set2, set3, object)

closure(set, object)

adj(object, set)

is.simplicial(set, object)

simplicialNodes(object)

is.complete(object, set = NULL)

is.decomposition(set, set2, set3, object)

nodes_(object)

nodes(object, ...)

\S4method{nodes}{igraph}(object, ...)

edges(object)

edges_(object)

addEdge(v1, v2, object)

removeEdge(v1, v2, object)
}
\arguments{
\item{object}{A graph.}

\item{op}{The operation or query.}

\item{set, set2, set3}{Sets of nodes in graph.}

\item{...}{additional arguments}

\item{v1, v2}{Vertex names}
}
\description{
Unified approach to query a graph about its properties
(based partly on functionality from gRbase and functionality
imported from RBGL).
}
\examples{

ug0 <- ug(~a:b + b:c:d + e)

separates("a", "d", c("b", "c"), ug0)
separates("a", "d", "c", ug0) 
is.simplicial("b", ug0)
simplicialNodes(ug0)

simplicialNodes(ug0)
}
