% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{cornerPoints}
\alias{cornerPoints}
\title{Calculate the corner points for the polytope Ax<=0.}
\usage{
cornerPoints(A, b, type = rep("c", ncol(A)), nonneg = rep(TRUE,
  ncol(A)))
}
\arguments{
\item{A}{Constraint matrix.}

\item{b}{Right hand side.}

\item{type}{A character vector of same length as number of variables. If
entry k is 'i' variable \eqn{k} must be integer and if 'c' continuous.}

\item{nonneg}{A boolean vector of same length as number of variables. If
entry k is TRUE then variable k must be non-negative.}
}
\value{
A data frame with a corner point in each row.
}
\description{
Calculate the corner points for the polytope Ax<=0.
}
\examples{
A <- matrix( c(3,-2, 1, 2, 4,-2,-3, 2, 1), nc = 3, byrow = TRUE)
b <- c(10, 12, 3)
cornerPoints(A, b, type = c("c", "c", "c"))
cornerPoints(A, b, type = c("i", "i", "i"))
cornerPoints(A, b, type = c("i", "c", "c"))
}
\author{
Lars Relund \email{lars@relund.dk}
}
