/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui;

import java.io.PrintStream;
import java.util.Hashtable;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.logging.ApplicationLog;
import org.af.commons.logging.LoggingSystem;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.DebugTextConsole;
import org.af.gMCP.gui.ErrorDialogGMCP;
import org.af.gMCP.gui.LoggingOutputStream;
import org.af.gMCP.gui.RCallServicesREngineWrapper;
import org.af.gMCP.gui.ReproducableLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rosuda.JRI.RMainLoopCallbacks;
import org.rosuda.JRI.Rengine;
import org.rosuda.REngine.JRI.JRIEngine;
import org.rosuda.REngine.REngine;
import org.rosuda.REngine.REngineException;

public class RControl {
    private static final Log logger = LogFactory.getLog(RControl.class);
    protected static RControl rc = null;
    protected static RCallServicesREngineWrapper rcs = null;
    public static DebugTextConsole console = null;
    static Hashtable<String, String> fractions = new Hashtable();

    public static RControl getRControl(boolean debug) {
        if (rc == null) {
            rc = new RControl(debug);
        }
        return rc;
    }

    public static RCallServicesREngineWrapper getR() {
        RControl.getRControl(true);
        return rcs;
    }

    protected RControl(boolean debug) {
        Rengine rengine;
        if (!LoggingSystem.alreadyInitiated()) {
            LoggingSystem.init((String)"/org/af/gMCP/gui/commons-logging.properties", (System.getProperty("eclipse") == null && !debug ? 1 : 0) != 0, (System.getProperty("eclipse") != null || debug ? 1 : 0) != 0, (ApplicationLog)new ApplicationLog());
            ErrorHandler.init((String)"rohmeyer@small-projects.de", (String)"http://www.algorithm-forge.com/report/bugreport.php", (boolean)true, (boolean)true, ErrorDialogGMCP.class);
        }
        if (!Rengine.versionCheck()) {
            System.err.println("Error: API version of the Rengine class and the native binary differ.");
            System.exit(1);
        }
        if ((rengine = Rengine.getMainEngine()) == null) {
            if (System.getProperty("eclipse") != null) {
                console = new DebugTextConsole();
                rengine = new Rengine(new String[]{"--vanilla"}, true, (RMainLoopCallbacks)console);
            } else {
                rengine = new Rengine();
            }
        }
        try {
            rcs = new RCallServicesREngineWrapper((REngine)new JRIEngine(rengine));
            if (System.getProperty("eclipse") != null) {
                rcs.eval("Sys.setlocale(\"LC_NUMERIC\", \"C\")");
                if (System.getProperty("libPath") != null) {
                    rcs.eval(".libPaths(new=\"" + System.getProperty("libPath") + "\")");
                }
                rcs.eval("require(gMCP)");
                rcs.eval("assign(\"env\", globalenv(), envir = gMCP:::gMCPenv)");
                rcs.eval("graph <- BonferroniHolm(3)");
                rcs.eval("graph2 <- BretzEtAl2011()");
                rcs.eval("m <- matrix(0, nrow=2, ncol=2)");
                rcs.eval("dunnettM <- matrix(c(1,1/2,1/2,1), nrow=2)");
                rcs.eval("mu <- c(0.860382, 0.9161474, 0.9732953)");
                rcs.eval("sdEst <- c(0.8759528, 1.291310, 0.8570892)");
                rcs.eval("pval <- c(0.01260, 0.05154, 0.02124)/2");
                rcs.eval("pHommel <- c(0.097, 0.015, 0.005, 0.006, 0.004, 0.008, 0.04)");
                rcs.eval("nSize <- list(c(10,10,10), c(20,20,20), c(20,10,30))");
            }
        }
        catch (REngineException e) {
            ErrorHandler.getInstance().makeErrDialog("Error creating RCallServicesREngine!", (Object)e);
        }
        if (System.getProperty("eclipse") == null && !debug) {
            System.setOut(new PrintStream(new LoggingOutputStream(logger), true));
        }
    }

    public static String getFraction(Double d, int cycles) {
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (Double.isInfinite(d)) {
            return "Infinity";
        }
        String result = fractions.get("" + d + ":" + cycles);
        if (result != null) {
            return result;
        }
        result = RControl.getR().eval("as.character(MASS::fractions(" + d + (cycles == -1 ? "" : ", cycles=" + cycles) + "))").asRChar().getData()[0];
        boolean accurate = RControl.getR().eval("abs(" + d + "-" + result + ")<" + Configuration.getInstance().getGeneralConfig().getAccuracy()).asRLogical().getData()[0];
        if (!accurate) {
            result = RControl.getR().eval("as.character(" + d + ")").asRChar().getData()[0];
        }
        fractions.put(d + ":" + cycles, result);
        return result;
    }

    public static String getFraction(Double d, boolean useUnicode) {
        return RControl.getFraction(d, useUnicode, -1);
    }

    public static String getFraction(Double d, boolean useUnicode, int cycles) {
        String f = RControl.getFraction(d, cycles);
        return f;
    }

    public static String getFraction(Double d) {
        return RControl.getFraction(d, -1);
    }

    public static boolean exists(String obj) {
        return RControl.getR().eval("exists(\"" + obj + "\")").asRLogical().getData()[0];
    }

    public static String getRString(double[] x) {
        String s = "c(";
        for (int i = 0; i < x.length; ++i) {
            double v = x[i];
            s = v == Double.NEGATIVE_INFINITY ? s + "-Inf," : (v == Double.POSITIVE_INFINITY ? s + "Inf," : (v == Double.NaN ? s + "NaN," : s + v + ","));
        }
        return s.substring(0, s.length() - 1) + ")";
    }

    public static void evalAndLog(String command) {
        ReproducableLog.logR(command);
        RControl.getR().eval(command);
    }

    public static String setSeed() {
        String code = "";
        if (Configuration.getInstance().getGeneralConfig().useSeed()) {
            code = "set.seed(" + Configuration.getInstance().getGeneralConfig().getSeed() + ")";
            RControl.getR().eval(code);
        }
        return code + "\n";
    }
}

