/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.dialogs;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.af.gMCP.gui.CreateGraphGUI;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.datatable.DataFramePanel;
import org.af.gMCP.gui.datatable.DataTableModel;
import org.af.gMCP.gui.datatable.RDataFrameRef;
import org.af.gMCP.gui.dialogs.GroupDialog;
import org.af.gMCP.gui.graph.EdgeWeight;
import org.af.gMCP.gui.graph.Node;
import org.af.jhlir.call.RChar;
import org.af.jhlir.call.RInteger;
import org.af.jhlir.call.RList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MatrixCreationDialog
extends JDialog
implements ActionListener,
ChangeListener {
    JButton ok = new JButton("Save matrix to R");
    CreateGraphGUI parent;
    Vector<Node> nodes;
    JTextArea jta = new JTextArea();
    DataFramePanel dfp;
    DataFramePanel dfpDiag;
    DataFramePanel dfpInterCor;
    DataFramePanel dfpIntraCor;
    JTextField tfname = new JTextField();
    JList hypotheses;
    JLabel warning = new JLabel();
    protected static Log logger = LogFactory.getLog(MatrixCreationDialog.class);
    JTabbedPane tabbedPane = new JTabbedPane();
    JButton reorder = new JButton("Apply reordering");
    JSpinner spinnerN;
    JSpinner spinnerN2;
    JButton jbAdd;
    JLabel jlBlock = new JLabel();
    JButton applyTE = new JButton("Calculate overall correlation");
    JSpinner spinnerNT;
    JSpinner spinnerNE;
    protected JComboBox jcbCorString = new JComboBox<String>(new String[]{"User defined design (edit the matrix)"});
    protected JComboBox jcbCorString2 = new JComboBox<String>(new String[]{"User defined design (edit the matrix)"});
    static final String NO_SD = "User defined design (edit the matrix)";

    public MatrixCreationDialog(CreateGraphGUI parent) {
        super(parent, "Specify correlation matrix", true);
        this.setLocationRelativeTo(parent);
        this.parent = parent;
        this.nodes = parent.getGraphView().getNL().getNodes();
        RDataFrameRef df = new RDataFrameRef();
        for (Node n : this.nodes) {
            df.addRowCol(n.getName());
            df.setValue(df.getColumnCount() - 1, df.getColumnCount() - 1, new EdgeWeight(1.0));
        }
        this.dfp = new DataFramePanel(df);
        this.dfp.getTable().getModel().diagEditable = true;
        this.setUpTabbedPane();
        this.getPossibleCorrelations();
        this.jta.setText("");
        this.warning.setForeground(Color.RED);
        this.ok.addActionListener(this);
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        this.getContentPane().setLayout((LayoutManager)new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.getContentPane().add((Component)this.tabbedPane, cc.xy(2, row));
        this.getContentPane().add((Component)new JScrollPane(this.dfp), cc.xy(4, row));
        this.getContentPane().add((Component)this.warning, cc.xy(2, row += 2));
        this.getContentPane().add((Component)this.ok, cc.xy(4, row));
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void setUpTabbedPane() {
        this.tabbedPane.add("General", this.getSortPane());
        this.tabbedPane.add("Block Diagonal", this.getBlockPane());
        this.tabbedPane.add("Treatments and Endpoints", this.getTEPane());
    }

    private JPanel getSortPane() {
        JPanel panel = new JPanel();
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu, pref, 5dlu";
        panel.setLayout((LayoutManager)new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.tfname.setText("corMat");
        panel.add((Component)new JLabel("Save matrix as:"), cc.xy(2, row));
        panel.add((Component)this.tfname, cc.xy(4, row));
        panel.add((Component)new JLabel("You can reorder the hypotheses by drag'n'drop:"), cc.xyw(2, row += 2, 3));
        row += 2;
        DefaultListModel<Node> lm = new DefaultListModel<Node>();
        for (Node n : this.nodes) {
            lm.addElement(n);
        }
        try {
            Class<?> cls = Class.forName("org.af.commons.widgets.JListDnD");
            Constructor<?> ct = cls.getConstructor(ListModel.class);
            this.hypotheses = (JList)ct.newInstance(lm);
            panel.add((Component)new JScrollPane(this.hypotheses), cc.xyw(2, row, 3));
        }
        catch (Exception e) {
            logger.warn((Object)e);
            this.hypotheses = new JList(lm);
            panel.add((Component)new JScrollPane(this.hypotheses), cc.xyw(2, row, 3));
            panel.add((Component)new JLabel("Reordering does currently not work for you due to Java 5"), cc.xyw(2, row += 2, 3));
        }
        this.reorder.addActionListener(this);
        panel.add((Component)this.reorder, cc.xy(4, row += 2));
        return panel;
    }

    private JPanel getBlockPane() {
        JPanel panel = new JPanel();
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        panel.setLayout((LayoutManager)new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.spinnerN = new JSpinner(new SpinnerNumberModel(2, 1, this.nodes.size(), 1));
        this.spinnerN.addChangeListener(this);
        panel.add((Component)new JLabel("Insert matrix of size:"), cc.xy(2, row));
        panel.add((Component)this.spinnerN, cc.xy(4, row));
        this.spinnerN2 = new JSpinner(new SpinnerNumberModel(1, 1, this.nodes.size() - 1, 1));
        this.spinnerN2.addChangeListener(this);
        panel.add((Component)new JLabel("Insert matrix at position:"), cc.xy(2, row += 2));
        panel.add((Component)this.spinnerN2, cc.xy(4, row));
        panel.add((Component)new JLabel("Use standard design:"), cc.xy(2, row += 2));
        panel.add((Component)this.jcbCorString2, cc.xy(4, row));
        this.jcbCorString2.addActionListener(this);
        panel.add((Component)this.jlBlock, cc.xyw(2, row += 2, 3));
        row += 2;
        RDataFrameRef df = new RDataFrameRef();
        for (int i = 0; i < 2; ++i) {
            df.addRowCol(this.nodes.get(i).getName());
            df.setValue(df.getColumnCount() - 1, df.getColumnCount() - 1, new EdgeWeight(1.0));
        }
        this.dfpDiag = new DataFramePanel(df);
        panel.add((Component)new JScrollPane(this.dfpDiag), cc.xyw(2, row, 3));
        this.jbAdd = new JButton("Add matrix on diagonal");
        this.jbAdd.addActionListener(this);
        panel.add((Component)this.jbAdd, cc.xyw(2, row += 2, 3));
        return panel;
    }

    private JPanel getTEPane() {
        JPanel panel = new JPanel();
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        panel.setLayout((LayoutManager)new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 2;
        panel.add((Component)this.getTEPane1(), cc.xyw(2, row, 3));
        panel.add((Component)this.getTEPane2(), cc.xyw(2, row += 2, 3));
        panel.add((Component)this.applyTE, cc.xyw(2, row += 2, 3));
        return panel;
    }

    private JPanel getTEPane1() {
        JPanel panel = new JPanel();
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu, fill:pref:grow, 5dlu";
        panel.setLayout((LayoutManager)new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.spinnerNT = new JSpinner(new SpinnerNumberModel(Math.max(2, this.nodes.size() / 2), 1, this.nodes.size(), 1));
        this.spinnerNT.addChangeListener(this);
        panel.add((Component)new JLabel("Number of Treatment Comparisons:"), cc.xy(2, row));
        panel.add((Component)this.spinnerNT, cc.xy(4, row));
        panel.add((Component)new JLabel("Use standard design:"), cc.xy(2, row += 2));
        panel.add((Component)this.jcbCorString, cc.xy(4, row));
        this.jcbCorString.addActionListener(this);
        row += 2;
        RDataFrameRef df = new RDataFrameRef();
        for (int i = 0; i < Math.max(2, this.nodes.size() / 2); ++i) {
            df.addRowCol("T" + (i + 1));
            df.setValue(df.getColumnCount() - 1, df.getColumnCount() - 1, new EdgeWeight(1.0));
        }
        this.dfpIntraCor = new DataFramePanel(df);
        panel.add((Component)new JScrollPane(this.dfpIntraCor), cc.xyw(2, row, 3));
        TitledBorder title = BorderFactory.createTitledBorder("Treatment correlation.");
        panel.setBorder(title);
        return panel;
    }

    private JPanel getTEPane2() {
        JPanel panel = new JPanel();
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu";
        panel.setLayout((LayoutManager)new FormLayout(cols, rows));
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.spinnerNE = new JSpinner(new SpinnerNumberModel(Math.max(2, this.nodes.size() / 2), 1, this.nodes.size(), 1));
        this.spinnerNE.addChangeListener(this);
        panel.add((Component)new JLabel("Number of Endpoints:"), cc.xy(2, row));
        panel.add((Component)this.spinnerNE, cc.xy(4, row));
        row += 2;
        RDataFrameRef df = new RDataFrameRef();
        for (int i = 0; i < Math.max(2, this.nodes.size() / 2); ++i) {
            df.addRowCol("E" + (i + 1));
            df.setValue(df.getColumnCount() - 1, df.getColumnCount() - 1, new EdgeWeight(1.0));
        }
        this.dfpInterCor = new DataFramePanel(df);
        panel.add((Component)new JScrollPane(this.dfpInterCor), cc.xyw(2, row, 3));
        TitledBorder title = BorderFactory.createTitledBorder("Correlation between endpoints");
        panel.setBorder(title);
        return panel;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok) {
            String name = RControl.getR().eval("make.names(\"" + this.tfname.getText() + "\")").asRChar().getData()[0];
            RControl.getR().eval(name + " <- " + this.dfp.getTable().getModel().getDataFrame().getRMatrix());
            this.dispose();
        } else if (e.getSource() == this.jbAdd) {
            int k = Integer.parseInt(this.spinnerN2.getModel().getValue().toString());
            int n = Integer.parseInt(this.spinnerN.getModel().getValue().toString());
            DataTableModel m = this.dfpDiag.getTable().getModel();
            DataTableModel m2 = this.dfp.getTable().getModel();
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    m2.setValueAt(m.getValueAt(i, j), i + k - 1, j + k - 1);
                }
            }
        } else if (e.getSource() != this.reorder && e.getSource() != this.applyTE) {
            if (e.getSource() == this.jcbCorString2) {
                if (this.jcbCorString2.getSelectedItem() == null || this.jcbCorString2.getSelectedItem().toString().equals(NO_SD)) {
                    return;
                }
                DataTableModel m = this.dfpDiag.getTable().getModel();
                int n = Integer.parseInt(this.spinnerN.getModel().getValue().toString());
                String s = this.jcbCorString2.getSelectedItem().toString();
                this.setMatrix(m, s, n);
            } else if (e.getSource() == this.jcbCorString) {
                if (this.jcbCorString.getSelectedItem() == null || this.jcbCorString.getSelectedItem().toString().equals(NO_SD)) {
                    return;
                }
                DataTableModel m = this.dfpIntraCor.getTable().getModel();
                int n = Integer.parseInt(this.spinnerNT.getModel().getValue().toString());
                String s = this.jcbCorString.getSelectedItem().toString();
                this.setMatrix(m, s, n);
            }
        }
        this.warning.setText(RControl.getR().eval("gMCP:::checkPSD(" + this.dfp.getTable().getRMatrix() + ")").asRChar().getData()[0]);
    }

    private void setMatrix(DataTableModel m, String s, int n) {
        String design = s.substring(0, s.indexOf(" "));
        String groups = s.substring(s.indexOf("(") + 1, s.indexOf("groups") - 1);
        GroupDialog gd = new GroupDialog(this.parent, Integer.parseInt(groups));
        String command = "gMCP:::getCorrMat(n=" + gd.getGroups() + ", type =\"" + design + "\")";
        double[] m2 = RControl.getR().eval(command).asRNumeric().getData();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                m.setValueAt(new EdgeWeight(m2[i * n + j]), i, j);
            }
        }
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.spinnerN || e.getSource() == this.spinnerN2) {
            int n = Integer.parseInt(this.spinnerN.getModel().getValue().toString());
            int j = Integer.parseInt(this.spinnerN2.getModel().getValue().toString());
            DataTableModel m = this.dfpDiag.getTable().getModel();
            m.removeAll();
            if (n + j - 1 > this.nodes.size()) {
                JOptionPane.showMessageDialog(this.parent, "The selected values " + n + "+" + j + " exceed the number of nodes+1.", "Impossible parameter combination", 0);
                return;
            }
            for (int i = j - 1; i < j - 1 + n; ++i) {
                m.addRowCol(this.nodes.get(i).getName());
                m.setValueAt(new EdgeWeight(1.0), m.getColumnCount() - 1, m.getColumnCount() - 1);
            }
            this.getPossibleCorrelations();
        } else if (e.getSource() == this.spinnerNT) {
            int n = Integer.parseInt(this.spinnerNT.getModel().getValue().toString());
            DataTableModel m = this.dfpIntraCor.getTable().getModel();
            m.removeAll();
            for (int i = 0; i < n; ++i) {
                m.addRowCol("T" + (i + 1));
                m.setValueAt(new EdgeWeight(1.0), m.getColumnCount() - 1, m.getColumnCount() - 1);
            }
            this.getPossibleCorrelations();
        } else if (e.getSource() == this.spinnerNE) {
            int n = Integer.parseInt(this.spinnerNE.getModel().getValue().toString());
            DataTableModel m = this.dfpInterCor.getTable().getModel();
            m.removeAll();
            for (int i = 0; i < n; ++i) {
                m.addRowCol("E" + (i + 1));
                m.setValueAt(new EdgeWeight(1.0), m.getColumnCount() - 1, m.getColumnCount() - 1);
            }
            this.getPossibleCorrelations();
        }
    }

    private void getPossibleCorrelations() {
        int i;
        RInteger groups;
        RChar designs;
        RList list;
        this.jcbCorString.removeAllItems();
        this.jcbCorString2.removeAllItems();
        int n = Integer.parseInt(this.spinnerNT.getModel().getValue().toString());
        int n2 = Integer.parseInt(this.spinnerN.getModel().getValue().toString());
        if (n != 0) {
            list = RControl.getR().eval("gMCP:::getAvailableStandardDesigns(" + n + ")").asRList();
            designs = list.get(0).asRChar();
            groups = list.get(1).asRInteger();
            this.jcbCorString.addItem(NO_SD);
            for (i = 0; i < designs.getLength(); ++i) {
                this.jcbCorString.addItem(designs.getData()[i] + " (" + groups.getData()[i] + " groups)");
            }
        }
        if (n2 != 0) {
            list = RControl.getR().eval("gMCP:::getAvailableStandardDesigns(" + n2 + ")").asRList();
            designs = list.get(0).asRChar();
            groups = list.get(1).asRInteger();
            this.jcbCorString2.addItem(NO_SD);
            for (i = 0; i < designs.getLength(); ++i) {
                this.jcbCorString2.addItem(designs.getData()[i] + " (" + groups.getData()[i] + " groups)");
            }
        }
    }
}

