/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;

public abstract class Box {
    public static boolean DEBUG = false;
    protected Color foreground;
    protected Color background;
    private Color prevColor;
    protected float width = 0.0f;
    protected float height = 0.0f;
    protected float depth = 0.0f;
    protected float shift = 0.0f;
    protected int type = -1;
    protected LinkedList<Box> children = new LinkedList();

    public void add(Box b) {
        this.children.add(b);
    }

    public void add(int pos, Box b) {
        this.children.add(pos, b);
    }

    protected Box() {
        this(null, null);
    }

    protected Box(Color fg, Color bg) {
        this.foreground = fg;
        this.background = bg;
    }

    public float getWidth() {
        return this.width;
    }

    public void negWidth() {
        this.width = -this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getDepth() {
        return this.depth;
    }

    public float getShift() {
        return this.shift;
    }

    public void setWidth(float w) {
        this.width = w;
    }

    public void setDepth(float d) {
        this.depth = d;
    }

    public void setHeight(float h) {
        this.height = h;
    }

    public void setShift(float s) {
        this.shift = s;
    }

    public abstract void draw(Graphics2D var1, float var2, float var3);

    public abstract int getLastFontId();

    protected void startDraw(Graphics2D g2, float x, float y) {
        this.prevColor = g2.getColor();
        if (this.background != null) {
            g2.setColor(this.background);
            g2.fill(new Rectangle2D.Float(x, y - this.height, this.width, this.height + this.depth));
        }
        if (this.foreground == null) {
            g2.setColor(this.prevColor);
        } else {
            g2.setColor(this.foreground);
        }
        this.drawDebug(g2, x, y);
    }

    protected void drawDebug(Graphics2D g2, float x, float y, boolean showDepth) {
        if (DEBUG) {
            Stroke st = g2.getStroke();
            g2.setStroke(new BasicStroke((float)Math.abs(1.0 / g2.getTransform().getScaleX()), 0, 0));
            if (this.width < 0.0f) {
                x += this.width;
                this.width = -this.width;
            }
            g2.draw(new Rectangle2D.Float(x, y - this.height, this.width, this.height + this.depth));
            if (showDepth) {
                Color c = g2.getColor();
                g2.setColor(Color.LIGHT_GRAY);
                g2.fill(new Rectangle2D.Float(x, y, this.width, this.depth));
                g2.setColor(c);
                g2.draw(new Rectangle2D.Float(x, y, this.width, this.depth));
            }
            g2.setStroke(st);
        }
    }

    protected void drawDebug(Graphics2D g2, float x, float y) {
        if (DEBUG) {
            this.drawDebug(g2, x, y, false);
        }
    }

    protected void endDraw(Graphics2D g2) {
        g2.setColor(this.prevColor);
    }
}

