/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.plaf.ext;

import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MouseScrollableUI
extends AbstractLayerUI<JScrollPane>
implements ActionListener {
    private JXLayer<JScrollPane> currentLayer;
    private Point scrollOrigin;
    private Point mousePoint;
    private Timer timer;
    private JLabel indicator;
    private Icon crissCrossIcon;
    private Icon horizontalIcon;
    private Icon verticalIcon;
    private boolean isAWTEventListenerEnabled;
    private ComponentListener componentListener = new ComponentAdapter(){

        public void componentResized(ComponentEvent componentEvent) {
            JXLayer jXLayer = (JXLayer)componentEvent.getComponent();
            if (MouseScrollableUI.this.indicator.isShowing() && jXLayer == MouseScrollableUI.this.currentLayer) {
                MouseScrollableUI.this.deactivateMouseScrolling(jXLayer);
            }
        }
    };

    public MouseScrollableUI() {
        this(false);
    }

    public MouseScrollableUI(boolean bl) {
        this.isAWTEventListenerEnabled = bl;
        this.timer = new Timer(20, this);
        this.crissCrossIcon = new ImageIcon(this.getClass().getResource("images/criss-cross.png"));
        this.horizontalIcon = new ImageIcon(this.getClass().getResource("images/horizontal.png"));
        this.verticalIcon = new ImageIcon(this.getClass().getResource("images/vertical.png"));
        this.indicator = new JLabel(this.crissCrossIcon);
        this.indicator.addMouseListener(new MouseAdapter(){});
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.addComponentListener(this.componentListener);
        JXLayer jXLayer = (JXLayer)jComponent;
        jXLayer.getGlassPane().setLayout(null);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        jComponent.removeComponentListener(this.componentListener);
    }

    @Override
    protected boolean isAWTEventListenerEnabled() {
        return this.isAWTEventListenerEnabled;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (!bl && this.indicator.isShowing()) {
            this.deactivateMouseScrolling(this.currentLayer);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent, JXLayer<JScrollPane> jXLayer) {
        super.processMouseEvent(mouseEvent, jXLayer);
        if (this.isMouseScrollingTrigger(mouseEvent) && (jXLayer.getView().getVerticalScrollBar().isShowing() || jXLayer.getView().getHorizontalScrollBar().isShowing())) {
            this.currentLayer = jXLayer;
            this.scrollOrigin = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.currentLayer);
            this.activateMouseScrolling(this.scrollOrigin, this.currentLayer);
            this.mousePoint = this.scrollOrigin;
            mouseEvent.consume();
        }
    }

    protected boolean isMouseScrollingTrigger(MouseEvent mouseEvent) {
        return mouseEvent.getID() == 501 && mouseEvent.getButton() == 2 && !mouseEvent.isPopupTrigger();
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent, JXLayer<JScrollPane> jXLayer) {
        super.processMouseMotionEvent(mouseEvent, jXLayer);
        if (this.indicator.isShowing()) {
            this.mousePoint = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.currentLayer);
            this.updateViewPosition(this.scrollOrigin, this.mousePoint, this.currentLayer);
        }
    }

    private void updateViewPosition(Point point, Point point2, JXLayer<JScrollPane> jXLayer) {
        JViewport jViewport = jXLayer.getView().getViewport();
        Point point3 = SwingUtilities.convertPoint(jXLayer, point2, this.indicator);
        if (!this.indicator.contains(point3)) {
            Point point4 = jViewport.getViewPosition();
            int n = point2.x - point.x;
            int n2 = point2.y - point.y;
            point4.x += n / 5;
            point4.y += n2 / 5;
            if (point4.x > jViewport.getView().getWidth() - jViewport.getWidth()) {
                point4.x = jViewport.getView().getWidth() - jViewport.getWidth();
            }
            if (point4.x < 0) {
                point4.x = 0;
            }
            if (point4.y > jViewport.getView().getHeight() - jViewport.getHeight()) {
                point4.y = jViewport.getView().getHeight() - jViewport.getHeight();
            }
            if (point4.y < 0) {
                point4.y = 0;
            }
            jViewport.setViewPosition(point4);
        }
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent, JXLayer<JScrollPane> jXLayer) {
        if (this.indicator.isShowing()) {
            InputEvent inputEvent;
            if (aWTEvent instanceof MouseEvent && (inputEvent = (MouseEvent)aWTEvent).getID() != 507 && inputEvent.getID() != 501 && (inputEvent.getID() != 502 && inputEvent.getID() != 500 || this.scrollOrigin.equals(this.mousePoint))) {
                super.eventDispatched(aWTEvent, jXLayer);
                return;
            }
            this.deactivateMouseScrolling(this.currentLayer);
            if (aWTEvent instanceof InputEvent) {
                inputEvent = (InputEvent)aWTEvent;
                inputEvent.consume();
            }
        } else {
            super.eventDispatched(aWTEvent, jXLayer);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.updateViewPosition(this.scrollOrigin, this.mousePoint, this.currentLayer);
    }

    private void activateMouseScrolling(Point point, JXLayer<JScrollPane> jXLayer) {
        jXLayer.getGlassPane().add(this.indicator);
        Dimension dimension = this.indicator.getPreferredSize();
        this.indicator.setBounds(point.x - dimension.width / 2, point.y - dimension.height / 2, dimension.width, dimension.height);
        this.updateIndicator(jXLayer);
        jXLayer.getGlassPane().repaint();
        this.timer.start();
    }

    private void updateIndicator(JXLayer<JScrollPane> jXLayer) {
        JViewport jViewport = jXLayer.getView().getViewport();
        Dimension dimension = jViewport.getExtentSize();
        Cursor cursor = Cursor.getPredefinedCursor(13);
        Icon icon = this.crissCrossIcon;
        if (dimension.width >= jViewport.getView().getWidth() && dimension.height >= jViewport.getView().getHeight() || dimension.width < jViewport.getView().getWidth() && dimension.height < jViewport.getView().getHeight()) {
            cursor = Cursor.getPredefinedCursor(13);
            icon = this.crissCrossIcon;
        } else if (dimension.width < jViewport.getView().getWidth()) {
            cursor = Cursor.getPredefinedCursor(11);
            icon = this.horizontalIcon;
        } else if (dimension.height < jViewport.getView().getHeight()) {
            cursor = Cursor.getPredefinedCursor(8);
            icon = this.verticalIcon;
        }
        this.indicator.setCursor(cursor);
        this.indicator.setIcon(icon);
    }

    private void deactivateMouseScrolling(JXLayer<JScrollPane> jXLayer) {
        this.indicator.setCursor(null);
        jXLayer.getGlassPane().remove(this.indicator);
        jXLayer.getGlassPane().repaint();
        this.timer.stop();
    }
}

