/*
 * Decompiled with CFR 0.152.
 */
package org.af.jhlir.backends.biocep;

import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import org.af.jhlir.backends.biocep.RCharBiocep;
import org.af.jhlir.backends.biocep.RDataFrameBiocep;
import org.af.jhlir.backends.biocep.REnvironmentBiocep;
import org.af.jhlir.backends.biocep.RFactorBiocep;
import org.af.jhlir.backends.biocep.RIntegerBiocep;
import org.af.jhlir.backends.biocep.RListBiocep;
import org.af.jhlir.backends.biocep.RListRefBiocep;
import org.af.jhlir.backends.biocep.RLogicalBiocep;
import org.af.jhlir.backends.biocep.RMatrixDoubleBiocep;
import org.af.jhlir.backends.biocep.RNumericBiocep;
import org.af.jhlir.backends.biocep.RObjectBiocep;
import org.af.jhlir.call.RCallServices;
import org.af.jhlir.call.REngineException;
import org.af.jhlir.call.RErrorException;
import org.af.jhlir.call.RInteger;
import org.af.jhlir.call.RNumeric;
import org.af.jhlir.call.RObj;
import org.af.jhlir.call.RRef;
import org.kchine.r.RChar;
import org.kchine.r.RDataFrame;
import org.kchine.r.REnvironment;
import org.kchine.r.RFactor;
import org.kchine.r.RList;
import org.kchine.r.RListRef;
import org.kchine.r.RLogical;
import org.kchine.r.RMatrix;
import org.kchine.r.RObject;
import org.kchine.r.server.RServices;
import org.kchine.r.server.ReferenceInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RCallServicesBiocep
extends RCallServices {
    private RServices rs;
    private List<String> history = new Vector<String>();

    public RCallServicesBiocep(RServices rs) {
        this.rs = rs;
        try {
            rs.evaluate("options(error = function() {.jhlir.errors <<- geterrmessage()})");
        }
        catch (RemoteException e) {
            throw new REngineException(e);
        }
    }

    public RServices getRServices() {
        return this.rs;
    }

    public RObject engineEval(String expression, boolean resolve) {
        try {
            RObject res = null;
            this.rs.evaluate(".jhlir.errors <<- NULL");
            String expression2 = expression.replace("\"", "\\\"");
            String s1 = "parse(text=\"" + expression2 + "\")";
            System.out.println(s1);
            this.rs.evaluate(s1);
            Object error = this.rs.getObjectConverted(".jhlir.errors");
            if (error != null) {
                throw new RErrorException(error.toString());
            }
            res = resolve ? this.rs.getObject(expression) : this.rs.getReference(expression);
            error = this.rs.getObjectConverted(".jhlir.errors");
            if (error != null) {
                throw new RErrorException(error.toString());
            }
            return res;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void evalVoid(String expression) throws REngineException {
        this.engineEval(expression, false);
    }

    @Override
    public RObj eval(String expression) throws REngineException {
        RObject robj = this.engineEval(expression, true);
        return this.wrapObject(robj);
    }

    @Override
    public RRef evalAndGetRef(String expression) throws RemoteException {
        ReferenceInterface ref = (ReferenceInterface)this.engineEval(expression, false);
        return this.wrapObject(ref);
    }

    @Override
    public void assign(String varName, String expression) throws RemoteException {
        this.evalVoid(varName + "<-" + expression);
    }

    @Override
    public RObj call(String function, Object ... args) {
        RObject robj;
        try {
            robj = this.rs.call(function, args);
        }
        catch (RemoteException e) {
            throw new REngineException(e);
        }
        return this.wrapObject(robj);
    }

    @Override
    public void put(String varName, Object obj) throws REngineException {
        try {
            if (obj instanceof RObjectBiocep) {
                this.rs.putAndAssign(((RObjectBiocep)obj).getWrapped(), varName);
            }
        }
        catch (RemoteException e) {
            throw new REngineException(e);
        }
    }

    public RRef wrapObject(ReferenceInterface ref) {
        if (ref instanceof RListRef) {
            return new RListRefBiocep(this, (RListRef)ref);
        }
        return null;
    }

    public RObjectBiocep wrapObject(RObject robj) {
        if (robj == null) {
            return null;
        }
        if (robj instanceof org.kchine.r.RNumeric) {
            return new RNumericBiocep(this, (org.kchine.r.RNumeric)robj);
        }
        if (robj instanceof org.kchine.r.RInteger) {
            return new RIntegerBiocep(this, (org.kchine.r.RInteger)robj);
        }
        if (robj instanceof RLogical) {
            return new RLogicalBiocep(this, (RLogical)robj);
        }
        if (robj instanceof RChar) {
            return new RCharBiocep(this, (RChar)robj);
        }
        if (robj instanceof RFactor) {
            return new RFactorBiocep(this, (RFactor)robj);
        }
        if (robj instanceof RMatrix) {
            return new RMatrixDoubleBiocep(this, (RMatrix)robj);
        }
        if (robj instanceof RList) {
            return new RListBiocep(this, (RList)robj);
        }
        if (robj instanceof RDataFrame) {
            return new RDataFrameBiocep(this, (RDataFrame)robj);
        }
        if (robj instanceof REnvironment) {
            return new REnvironmentBiocep(this, (REnvironment)robj);
        }
        return null;
    }

    @Override
    public String[] getWarning() {
        String[] warning;
        try {
            Object o = this.rs.getObjectConverted("names(warnings())");
            warning = o instanceof String[] ? (String[])o : new String[]{(String)o};
        }
        catch (Exception e) {
            throw new REngineException(e);
        }
        if (warning != null && warning.length > 0 && warning[0] != null && !warning[0].equals("NO_WARNING")) {
            return warning;
        }
        return null;
    }

    @Override
    public RNumeric createRObject(double[] val) {
        return null;
    }

    @Override
    public RInteger createRObject(int[] val) {
        return null;
    }

    @Override
    public org.af.jhlir.call.RChar createRObject(String[] val) {
        return null;
    }

    @Override
    public org.af.jhlir.call.RLogical createRObject(boolean[] val) {
        return null;
    }

    @Override
    public List<String> getHistory() {
        return this.history;
    }

    static {
        RCallServices.NA_RINTEGER = Integer.MIN_VALUE;
        RCallServices.NA_RNUMERIC = Double.NaN;
        RCallServices.NA_RLOGICAL = null;
        RCallServices.NA_CHAR = "NA";
        RCallServices.NA_FACTOR = null;
    }
}

