/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.pdf.DocumentFont;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.fonts.cmaps.CMap;
import com.lowagie.text.pdf.fonts.cmaps.CMapParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class CMapAwareDocumentFont
extends DocumentFont {
    private PdfDictionary fontDic;
    private CMap cmap;

    public CMapAwareDocumentFont(PRIndirectReference pRIndirectReference) {
        super(pRIndirectReference);
        this.fontDic = (PdfDictionary)PdfReader.getPdfObjectRelease(pRIndirectReference);
        this.processToUni();
    }

    private void processToUni() {
        PdfObject pdfObject = this.fontDic.get(PdfName.TOUNICODE);
        if (pdfObject == null) {
            return;
        }
        try {
            byte[] byArray = PdfReader.getStreamBytes((PRStream)PdfReader.getPdfObjectRelease(pdfObject));
            CMapParser cMapParser = new CMapParser();
            this.cmap = cMapParser.parse(new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            throw new Error("Unable to obtain cmap - " + iOException.getMessage(), iOException);
        }
    }

    public String encode(byte[] byArray, int n, int n2) {
        if (this.cmap != null) {
            if (n2 > byArray.length) {
                System.out.println("Length problem...");
            }
            return this.cmap.lookup(byArray, n, n2);
        }
        if (n2 == 1) {
            return new String(byArray, n, 1);
        }
        throw new Error("Multi-byte glyphs not implemented yet");
    }
}

