/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.options;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import org.af.commons.Localizer;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.widgets.WidgetFactory;
import org.af.commons.widgets.buttons.HorizontalButtonPane;
import org.af.commons.widgets.buttons.OkApplyCancelButtonPane;
import org.af.commons.widgets.validate.ValidationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.config.Configuration;
import org.mutoss.gui.options.GeneralPanel;
import org.mutoss.gui.options.PlotPanel;
import org.mutoss.gui.options.SetLookAndFeelException;

public class OptionsDialog
extends JDialog
implements ActionListener {
    private static final Log logger = LogFactory.getLog(OptionsDialog.class);
    private JTabbedPane tabbedPane;
    private GeneralPanel generalPanel;
    private PlotPanel plotPanel;
    private OkApplyCancelButtonPane bp;
    private Configuration conf;
    private Properties returnVal;
    private boolean revertChange = false;
    JFrame parent;

    public OptionsDialog(JFrame p) {
        super(p);
        this.parent = p;
        this.conf = Configuration.getInstance();
        this.setModal(true);
        this.setTitle(Localizer.getInstance().getString("SGTK_OPTIONS_OPTIONSDIALOG_TITLE"));
        this.setDefaultCloseOperation(2);
        this.makeComponents();
        this.doTheLayout();
        this.pack();
        this.setLocationRelativeTo(p);
        this.setVisible(true);
    }

    private void makeComponents() {
        this.tabbedPane = new JTabbedPane();
        this.generalPanel = new GeneralPanel(this.parent, this);
        this.plotPanel = new PlotPanel(this.conf);
        this.bp = new OkApplyCancelButtonPane();
    }

    private void doTheLayout() {
        Localizer loc = Localizer.getInstance();
        this.tabbedPane.addTab(loc.getString("SGTK_OPTIONS_OPTIONSDIALOG_GENERALTAB"), this.generalPanel);
        Container cp = this.getContentPane();
        cp.add(this.tabbedPane);
        cp = WidgetFactory.makeDialogPanelWithButtons((Container)cp, (HorizontalButtonPane)this.bp, (ActionListener)this);
        this.setContentPane(cp);
    }

    public void actionPerformed(ActionEvent e) {
        logger.debug((Object)("Got ActionCommand " + e.getActionCommand()));
        if (e.getActionCommand().equals("OK") || e.getActionCommand().equals("APPLY")) {
            try {
                this.generalPanel.setProperties();
                this.plotPanel.setProperties();
                if (e.getActionCommand().equals("OK")) {
                    this.dispose();
                }
            }
            catch (ValidationException exc) {
                JOptionPane.showMessageDialog(this, exc.getMessage());
            }
            catch (SetLookAndFeelException exc) {
                ErrorHandler.getInstance().makeErrDialog(exc.getMessage(), (Object)exc);
            }
        }
        if (e.getActionCommand().equals("CANCEL")) {
            this.dispose();
        }
    }
}

