/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.graph;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.gui.graph.ControlMGraph;
import org.mutoss.gui.graph.Node;
import org.mutoss.gui.graph.PPanel;

public class PView
extends JPanel {
    JLabel statusBar;
    private static final Log logger = LogFactory.getLog(PView.class);
    private ControlMGraph control;
    private Vector<PPanel> panels = new Vector();
    CellConstraints cc = new CellConstraints();
    JLabel label = new JLabel("Total \u03b1: 0");
    GridBagConstraints c = new GridBagConstraints();
    List<Double> pValues = null;
    DecimalFormat format = new DecimalFormat("#.####");

    public PView(ControlMGraph abstractGraphControl) {
        this.control = abstractGraphControl;
        this.setLayout(new GridBagLayout());
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.c.fill = 1;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.ipadx = 0;
        this.c.ipady = 0;
        this.setUp();
    }

    public void addPPanel(Node node) {
        this.panels.add(new PPanel(node, this));
        logger.debug((Object)("Added panel for node " + node.getName()));
        this.setUp();
    }

    public void savePValues() {
        String debug = "Saving : ";
        this.pValues = new Vector<Double>();
        for (PPanel panel : this.panels) {
            this.pValues.add(panel.getP());
            debug = debug + this.format.format(panel.getP()) + "; ";
        }
        logger.debug((Object)debug);
    }

    public void restorePValues() {
        String debug = "Restoring : ";
        if (this.pValues != null) {
            for (int i = 0; i < this.pValues.size(); ++i) {
                this.panels.get(i).setP(this.pValues.get(i));
                debug = debug + this.format.format(this.pValues.get(i)) + "; ";
            }
        }
        logger.debug((Object)debug);
    }

    public void setUp() {
        JPanel panel = new JPanel();
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu";
        for (PPanel p : this.panels) {
            rows = rows + ", pref, 5dlu";
        }
        FormLayout layout = new FormLayout(cols, rows);
        panel.setLayout((LayoutManager)layout);
        panel.add((Component)new JLabel("Hypothesis"), this.cc.xy(2, 2));
        panel.add((Component)new JLabel("Significance Level"), this.cc.xy(4, 2));
        panel.add((Component)new JLabel("P-Value"), this.cc.xy(6, 2));
        int row = 4;
        for (PPanel p : this.panels) {
            int col = 2;
            for (Component c : p.getComponent()) {
                panel.add(c, this.cc.xy(col, row));
                col += 2;
            }
            row += 2;
        }
        panel.add((Component)this.label, this.cc.xyw(2, row, 7));
        panel.revalidate();
        this.removeAll();
        this.add((Component)new JScrollPane(panel), this.c);
    }

    public void updateLabels() {
        double alpha = 0.0;
        for (PPanel p : this.panels) {
            if (p.rejected.booleanValue()) continue;
            alpha += p.w;
        }
        String text = "Total \u03b1: " + this.format.format(alpha);
        if (alpha >= 1.0) {
            this.label.setForeground(Color.RED);
            text = text + "; The total \u03b1 is greater or equal 1!";
        } else {
            this.label.setForeground(Color.BLACK);
        }
        this.label.setText(text);
    }

    public void recalculate() {
        for (PPanel p : this.panels) {
            p.update();
        }
        this.revalidate();
        this.repaint();
    }

    public void newGraph() {
        this.panels.removeAllElements();
    }

    public void removePPanel(Node node) {
        for (int i = this.panels.size() - 1; i >= 0; --i) {
            if (this.panels.get((int)i).node != node) continue;
            this.panels.remove(i);
            logger.debug((Object)("Removed panel for node " + node.getName()));
        }
        this.setUp();
    }

    public void setTesting(boolean b) {
        PPanel.setTesting(b);
        for (PPanel p : this.panels) {
            p.keyTyped(null);
        }
    }

    public String getPValuesString() {
        String s = "c(";
        for (double p : this.pValues) {
            s = s + p + ", ";
        }
        return s.substring(0, s.length() - 2) + ")";
    }
}

