% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fxTWAPLS.R
\name{plot_train}
\alias{plot_train}
\title{Plot the training results}
\usage{
plot_train(train_output, col)
}
\arguments{
\item{train_output}{Training output, can be the output of WA-PLS, WA-PLS with
\code{fx} correction, TWA-PLS, or TWA-PLS with \code{fx} correction.}

\item{col}{Choose which column of the fitted value to plot, in other words,
how many number of components you want to use.}
}
\value{
Plotting status.
}
\description{
Plot the training results, the black line is the 1:1 line, the red line is
the linear regression line to fitted and \code{x}, which shows the degree
of overall compression.
}
\examples{
\dontrun{
# Load modern pollen data
modern_pollen <- read.csv("/path/to/modern_pollen.csv")
                                      
# Extract taxa
taxaColMin <- which(colnames(modern_pollen) == "taxa0")
taxaColMax <- which(colnames(modern_pollen) == "taxaN")
taxa <- modern_pollen[, taxaColMin:taxaColMax]

# MTCO
## WAPLS and fxWAPLS
fit_Tmin <- fxTWAPLS::WAPLS.w(taxa, modern_pollen$Tmin, nPLS = 5)
fit_f_Tmin <- fxTWAPLS::WAPLS.w(taxa, 
                                modern_pollen$Tmin, 
                                nPLS = 5, 
                                usefx = TRUE, 
                                fx_method = "bin",
                                bin = 0.02)
## TWAPLS and fxTWAPLS
fit_t_Tmin <- fxTWAPLS::TWAPLS.w(taxa, modern_pollen$Tmin, nPLS = 5)
fit_tf_Tmin <- fxTWAPLS::TWAPLS.w(taxa, 
                                  modern_pollen$Tmin, 
                                  nPLS = 5, 
                                  usefx = TRUE, 
                                  fx_method = "bin",
                                  bin = 0.02)
fxTWAPLS::plot_train(fit_Tmin, 3)
fxTWAPLS::plot_train(fit_f_Tmin, 3)
fxTWAPLS::plot_train(fit_t_Tmin, 3)
fxTWAPLS::plot_train(fit_tf_Tmin, 3)
}

}
\seealso{
\code{\link{TWAPLS.w}} and \code{\link{WAPLS.w}}
}
