% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{summary.boottest}
\alias{summary.boottest}
\title{S3 method to summarize objects of class boottest}
\usage{
\method{summary}{boottest}(object, digits = 3, ...)
}
\arguments{
\item{object}{object of type boottest}

\item{digits}{rounding of output. 3 by default}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Returns result summaries for objects of type boottest
}
\description{
S3 method to summarize objects of class boottest
}
\examples{
requireNamespace("fwildclusterboot")
data(voters)
lm_fit <- lm(
proposition_vote ~ treatment + ideology1 + log_income + Q1_immigration,
  data = voters
)
boot <- boottest(lm_fit,
  B = 9999,
  param = "treatment",
  clustid = "group_id1"
)
summary(boot)
}
