% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fls.R
\name{diamond}
\alias{diamond}
\title{Fuzzy Linear Regression using the Fuzzy Least Squares Method}
\usage{
diamond(x, y)
}
\arguments{
\item{x}{two column matrix with the second column representing independent variable
observations. The first column is related to the intercept, so it consists of ones.
Missing values not allowed.}

\item{y}{matrix of dependent variable observations. The first column contains the 
central tendency, the second column the left spread and the third column the right
spread of non-symmetric triangular fuzzy numbers. Missing values not allowed.}
}
\value{
Returns a \code{fuzzylm} object that includes the model coefficients, limits
  for data predictions from the model and the input data.
}
\description{
The function calculates fuzzy regression coeficients using the fuzzy least squares 
(FLS) method proposed by Diamond (1988) for non-symmetric triangular fuzzy numbers.
}
\details{
The FLS method for the fuzzy linear regression fits a simple model.
}
\references{
Diamond, P. (1988) Fuzzy least squares. \emph{Information Sciences}
   46(3): 141-157.
}
\seealso{
\code{\link{fuzzylm}}
}
