% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{createAccumulators}
\alias{createAccumulators}
\title{Create accumulator closure}
\usage{
createAccumulators()
}
\value{
A closure that accepts commands to access and append new data onto
   data structures as the program executes. The closure created by this
   function accepts two arguments: (1) the command and (2) an element to
   be appended to the end of the data structure of the command. These two
   arguments must be entered in this exact order. The first argument (the
   command) can be one of the following options:
   \code{return model information}, \code{append model information},
   \code{return locations}, and \code{append location list}. The second
   argument for the created closure should only be used
   in conjunction with the two "append" commands for the closure.
}
\description{
This function creates a closure that holds, adds to, and returns data
structures that the user wishes to grow at various points in the execution of
the package (e.g., location and model information dataframes).
}
\details{
As an example, when the generated
closure is used with the command "append location list", it will add
information on the cities and closest grid point locations based
on the climate model it has just completed analyzing to a growing
dataframe with this information for all climate models. After the function
run to generate the heat wave projections is completed, this closure can
be used with the command "return locations" to output the completed
dataframe of this location information.The closure can be used in a
similar manner to aggregate and then return meta-data on the models
analyzed based on their inclusion in the user-specified projections
directory.
}

