#' Calculate number of extreme_events
#'
#' This function takes a dataframe of extreme events, as created by
#' \code{\link{gen_hw_set}}, and calculates the number of events in
#' the dataframe.
#'
#' To calculate the number of extreme events, this function determines the number
#' of rows in the dataframe, since \code{\link{gen_hw_set}} outputs a
#' dataframe with one and only one row per event.
#'
#' @param hw_datafr A dataframe of extreme events and their characteristics, as
#'    created by \code{\link{gen_hw_set}}
#'
#' @return A numeric value with the number of extreme events in a dataframe of
#'    events, as generated by \code{\link{gen_hw_set}}.
#'
#' @note This function is an example of a function that can be created and
#'    used to explore extreme events using the \code{\link{apply_all_models}}
#'    function.
#'
#' @examples
#' data(hw_datafr)
#' number_of_heatwaves(hw_datafr)
#'
#' @export
number_of_heatwaves <- function(hw_datafr){
        out <- nrow(hw_datafr)
        return(out)
}

#' Calculate total event days
#'
#' This function takes a dataframe of heat waves, as created by
#' \code{\link{gen_hw_set}}, and calculates the total number of extreme event days in
#' the dataframe (sum of the number of days in each event for all events
#' in the dataset).
#'
#' @param hw_datafr A dataframe of extreme events and their characteristics, as
#'    created by \code{\link{gen_hw_set}}
#'
#' @return A numeric value with the number of extreme event days in a dataframe
#'    of heat waves, as generated by \code{\link{gen_hw_set}}.
#'
#' @note This function is an example of a function that can be created and
#'    used to explore extreme events using the \code{\link{apply_all_models}}
#'    function.
#'
#' @examples
#' data(hw_datafr)
#' heatwave_days(hw_datafr)
#'
#' @export
heatwave_days <- function(hw_datafr){
        out <- sum(hw_datafr$length)
        return(out)
}

#' Calculate average length of extreme events
#'
#' This function takes a dataframe of extreme events, as created by
#' \code{\link{gen_hw_set}}, and calculates the average length (in days) of
#' events in the dataframe.
#'
#' @param hw_datafr A dataframe of extreme events and their characteristics, as
#'    created by \code{\link{gen_hw_set}}
#'
#' @return A numeric value with the average length of extreme events in a
#'    dataframe of events, as generated by \code{\link{gen_hw_set}}.
#'
#' @note This function is an example of a function that can be created and
#'    used to explore extreme events using the \code{\link{apply_all_models}}
#'    function.
#'
#' @examples
#' data(hw_datafr)
#' average_length(hw_datafr)
#'
#' @export
average_length <- function(hw_datafr){
        out <- mean(hw_datafr$length)
        return(out)
}

#' Calculate average variable of extreme events
#'
#' This function takes a dataframe of extreme events, as created by
#' \code{\link{gen_hw_set}}, and calculates the average of the variable
#' (e.g., temperature0 during each extreme event across all events in the
#' dataframe.
#'
#' @param hw_datafr A dataframe of extreme events and their characteristics, as
#'    created by \code{\link{gen_hw_set}}
#'
#' @return A numeric value with the average variable
#'    during all heat waves for a dataset of heat waves, as generated by
#'    \code{\link{gen_hw_set}}. This value is the mean of the average variable
#'    within each event, not the average variable across all
#'    event days (to calculate that, you would need to calculate a weighted
#'    mean, weighted by the number of days in each heat wave).
#'
#' @note This function is an example of a function that can be created and
#'    used to explore extreme events using the \code{\link{apply_all_models}}
#'    function.
#'
#' @examples
#' data(hw_datafr)
#' average_mean_temp(hw_datafr)
#'
#' @export
average_mean_temp <- function(hw_datafr){
        out <- mean(hw_datafr$mean.var)
        return(out)
}
