% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend_api-11.ClusterFutureBackend-class.R
\name{cluster}
\alias{cluster}
\title{Create a cluster future whose value will be resolved asynchronously in a parallel process}
\usage{
cluster(
  ...,
  workers = availableWorkers(constraints = "connections"),
  gc = FALSE,
  earlySignal = FALSE,
  persistent = FALSE,
  envir = parent.frame()
)
}
\arguments{
\item{workers}{A \code{\link[parallel:makeCluster]{cluster}} object,
a character vector of host names, a positive numeric scalar,
or a function.
If a character vector or a numeric scalar, a \code{cluster} object
is created using \code{\link[parallelly:makeClusterPSOCK]{makeClusterPSOCK}(workers)}.
If a function, it is called without arguments \emph{when the future
is created} and its value is used to configure the workers.
The function should return any of the above types.}

\item{gc}{If TRUE, the garbage collector run (in the process that
evaluated the future) only after the value of the future is collected.
Exactly when the values are collected may depend on various factors such
as number of free workers and whether \code{earlySignal} is TRUE (more
frequently) or FALSE (less frequently).
\emph{Some types of futures ignore this argument.}}

\item{earlySignal}{Specified whether conditions should be signaled as soon
as possible or not.}

\item{persistent}{If FALSE, the evaluation environment is cleared
from objects prior to the evaluation of the future.}

\item{envir}{The \link{environment} from where global objects should be
identified.}

\item{\ldots}{Additional named elements passed to \code{\link[=Future]{Future()}}.}
}
\value{
A ClusterFuture.
}
\description{
\emph{WARNING: This function must never be called.
It may only be used with \code{\link[=plan]{plan()}}}
}
\details{
A cluster future is a future that uses cluster evaluation,
which means that its \emph{value is computed and resolved in
parallel in another process}.

This function is must \emph{not} be called directly.  Instead, the
typical usages are:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Evaluate futures via a single background R process on the local machine
plan(cluster, workers = I(1))

# Evaluate futures via two background R processes on the local machine
plan(cluster, workers = 2)

# Evaluate futures via a single R process on another machine on on the
# local area network (LAN)
plan(cluster, workers = "raspberry-pi")

# Evaluate futures via a single R process running on a remote machine
plan(cluster, workers = "pi.example.org")

# Evaluate futures via four R processes, one running on the local machine,
# two running on LAN machine 'n1' and one on a remote machine
plan(cluster, workers = c("localhost", "n1", "n1", "pi.example.org"))
}\if{html}{\out{</div>}}
}
\examples{
\donttest{

## Use cluster futures
cl <- parallel::makeCluster(2, timeout = 60)
plan(cluster, workers = cl)

## A global variable
a <- 0

## Create future (explicitly)
f <- future({
  b <- 3
  c <- 2
  a * b * c
})

## A cluster future is evaluated in a separate process.
## Regardless, changing the value of a global variable will
## not affect the result of the future.
a <- 7
print(a)

v <- value(f)
print(v)
stopifnot(v == 0)

## CLEANUP
parallel::stopCluster(cl)

}
}
\seealso{
For alternative future backends, see the 'A Future for R: Available Future
Backends' vignette and \url{https://www.futureverse.org/backends.html}.
}
