% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backtrace.R
\name{backtrace}
\alias{backtrace}
\title{Back trace the expressions evaluated when an error was caught}
\usage{
backtrace(future, envir = parent.frame(), ...)
}
\arguments{
\item{future}{A future with a caught error.}

\item{envir}{the environment where to locate the future.}

\item{\dots}{Not used.}
}
\value{
A @list with the future's call stack that led up to the error.
}
\description{
Back trace the expressions evaluated when an error was caught
}
\examples{
my_log <- function(x) log(x)
foo <- function(...) my_log(...)

f <- future({ foo("a") })
res <- tryCatch({
  v <- value(f)
}, error = function(ex) {
  t <- backtrace(f)
  print(t)
})
}
