% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future.R
\name{future}
\alias{future}
\title{Create a future}
\usage{
future(expr, envir = parent.frame(), substitute = TRUE, ...,
  evaluator = plan())
}
\arguments{
\item{expr}{An R \link[base]{expression}.}

\item{envir}{The \link{environment} from where global
objects should be identified.  Depending on "evaluator",
it may also be the environment in which the expression
is evaluated.}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{evaluator}{The actual function that evaluates
\code{expr} and returns a future.  The evaluator function
should accept all the same arguments as this function
(except \code{evaluator}).}

\item{\dots}{Additional arguments passed to the "evaluator".}
}
\value{
A \link{Future}.
}
\description{
Creates a future from an expression and returns it.
The state of the future is either unresolved or resolved.
When it becomes resolved, at some point in the future,
its value can be retrieved.
}
\examples{
plan(lazy)

f <- future({
  a <- 7
  b <- 3
  c <- 2
  a * b * c
})

print(resolved(f))
y <- value(f)
print(y)
}
\seealso{
It is recommended that the evaluator is \emph{non-blocking}
(returns immediately), but it is not required.
The default evaluator function is \code{\link{eager}()},
but this can be changed via \code{\link{plan}()} function.
}

