# WARNING - Generated by {fusen} from dev/flat_get_package_structure.Rmd: do not edit by hand

#' Get all functions created in a R file
#'
#' @param file A R file
#'
#' @return A character vector of function names
#'
#' @export
#' @examples
#' file_path <- tempfile(fileext = ".R")
#' cat(
#'   "my_fun <- function() {1}",
#'   "my_fun2 <- function() {2}",
#'   sep = "\n",
#'   file = file_path
#' )
#' get_all_created_funs(file_path)
get_all_created_funs <- function(file) {
  stopifnot(tools::file_ext(file) %in% c("R", "r"))
  # Get each bloc of code
  parts_parsed <- parse(file, keep.source = TRUE)
  # We cannot directly get as.character as it would
  # remove character quotes from text only lines
  # like a line with : "_example" fails
  parts <- lapply(attr(parts_parsed, "srcref"), as.character)

  all_functions <- lapply(
    seq_along(parts), function(x) {
      out <- list()
      out$code <- as.character(parts[x])
      name <- parse_fun(out)$fun_name
      return(name)
    }
  ) %>% unlist()

  all_functions_no_na <- all_functions[!is.na(all_functions)]

  return(all_functions_no_na)
}
