% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{fit_ftree}
\alias{fit_ftree}
\title{Clustering of components for the performances of assemblages}
\usage{
fit_ftree(fobs, mOccur,
         xpr = stats::setNames(rep(1, length(fobs)),rep("a", length(fobs))),
         affectElt  = rep(1, dim(mOccur)[2]),
         opt.method = "divisive",
         opt.mean   = "amean",
         opt.model  = "byelt",
         opt.nbMax  = dim(mOccur)[2] )
}
\arguments{
\item{fobs}{a numeric vector. The vector \code{fobs} contains the
quantitative performances of assemblages.}

\item{mOccur}{a matrix of occurrence (occurrence of elements).
Its first dimension equals to \code{length(fobs)}. Its second dimension
 equals to the number of elements.}

\item{xpr}{a vector of numerics of \code{length(fobs)}.
The vector \code{xpr} contains the weight of each experiment,
and the labels (in \code{names(xpr)}) of different experiments.
The weigth of each experiment is used
in the computation of the Residual Sum of Squares
in the function \code{rss_clustering}.
The used formula is \code{rss}
if each experiment has the same weight.
The used formula is \code{wrss}
(barycenter of RSS for each experiment)
if each experiment has different weights.
All assemblages that belong to a given experiment
should then have a same weigth.
Each experiment is identified by its names (\code{names(xpr)})
and the RSS of each experiment is weighted by values of \code{xpr}.
The vector \code{xpr} is generated
by the function \code{stats::setNames}.}

\item{affectElt}{a vector of integers
of \code{length(affectElt) == dim(mOccur)[1]},
that is the number of components.
The vector contains the labels of different functional clusters
to which each component belongs.
Each functional cluster is labelled as an integer, and
each component must be identified by its name in \code{names(affectElt)}.
The number of functional clusters defined in \code{affectElt}
determines an \emph{a priori} level of component clustering
(\code{level <- length(unique(affectElt))}).\cr

If \code{affectElt = NULL} (value by default),
the option \code{opt.method} must be filled out.
A tree is built,
from a unique trunk to as many leaves as components
by using the specified method. \cr

If \code{affectElt} is specified,
the option \code{opt.method} does not need to be filled out.
\code{affectElt} determines an \emph{a priori}
level of component clustering,
and a tree is built:
\emph{(i)} by using \code{opt.method =  "divisive"}
from the \emph{a priori} defined level in tree towards
as many leaves as components;
\emph{(ii)} by using \code{opt.method =  "agglomerative"}
from the \emph{a priori} defined level in tree towards the tree trunk
(all components are together withi a trivial singleton).}

\item{opt.method}{a string that specifies the method to use.
\code{opt.method = c("divisive", "agglomerative", "complete")}.
All the methods generate a hierarchical tree.
Each tree is complete, running from a unique trunk
to as many leaves as components. \cr

If \code{opt.method = "divisive"}, the components are clustered
according to a hierarchical process
by using a divisive method,
from the trivial cluster where all components are together,
towards the clustering where each component is a cluster. \cr

If \code{opt.method = "agglomerative"}, the components are clustered
according to a hierarchical process
by using an agglomerative method,
from the trivial clustering where each component is a clsuter,
towards the cluster where all components are together.
The method that gives the best result is \code{opt.method = "divisive"}. \cr

If \code{opt.method = "complete"}, \code{affectElt} must be specified.
\code{affectElt} determines a level of component clustering,
and a tree is built:
\emph{(i)} by using \code{opt.method =  "divisive"}
from the defined level in tree towards as many leaves as components;
\emph{(ii)} by using \code{opt.method =  "agglomerative"}
from the defined level in tree towards the trunk of tree.}

\item{opt.mean}{a character equals to \code{"amean"} or \code{"gmean"}.
Switchs to arithmetic formula if \code{opt.mean = "amean"}.
Switchs to geometric formula if \code{opt.mean = "gmean"}. \cr

Modelled performances are computed
using arithmetic mean (\code{opt.mean = "amean"})
or geometric mean (\code{opt.mean = "gmean"})
according to \code{opt.model}.}

\item{opt.model}{a character equals to \code{"bymot"} or \code{"byelt"}.
Switchs to simple mean by assembly motif if \code{opt.model = "bymot"}.
Switchs to linear model with assembly motif if \code{opt.model = "byelt"}.
  \cr

If \code{opt.model = "bymot"},
modelled performances are means
of performances of assemblages
that share a same assembly motif
by including all assemblages that belong to a same assembly motif. \cr

If \code{opt.model = "byelt"},
modelled performances are the average
of mean performances of assemblages
that share a same assembly motif
and that contain the same components
as the assemblage to predict.
This procedure corresponds to a linear model within each assembly motif
based on the component occurrence in each assemblage.
If no assemblage contains component belonging to assemblage to predict,
performance is the mean performance of all assemblages
as in \code{opt.model = "bymot"}.}

\item{opt.nbMax}{an integer, comprizes between 1 and nbElt,
that indicates the last level of hierarchical tree to compute.
This option is very useful to shorten computing-time
in the test-functions
\code{\link{ftest_components}}, \code{\link{ftest_assemblages}},
\code{\link{ftest_performances}}, \code{\link{fboot_assemblages}},
\code{\link{fboot_performances}} or \code{\link{ftest}}
where the function \code{\link{fit_ftree}} is run very numerous times.}
}
\value{
Return a primary tree of clustering of components
for their effect on the performances of component assemblages.
}
\description{
The function checks the inputs,
then switch on different methods of component clustering
according to the option \code{opt.method}.
Three methods (\code{opt.method = c("sort", "divisive", "agglomerative")})
generate a hierarchical tree.
The last method (\code{opt.method = "cluster"})
generates a non-hierarchical tree of clustering.
}
\details{
None.
}
\keyword{internal}
