% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validating.R
\name{compute_motif_stats}
\alias{compute_motif_stats}
\title{Statistics of assembly motifs}
\usage{
compute_motif_stats(tCal, tPrd, mMotifs)
}
\arguments{
\item{tCal}{a numeric matrix.
This matrix is the matrix of performances predicted by the valid tree model.}

\item{tPrd}{a numeric matrix.
This matrix is the matrix of performances predicted by cross-validation.}

\item{mMotifs}{a numeric matrix.
This matrix is the matrix of assembly motifs.}
}
\value{
Returns the statistics for each assembly motif.
}
\description{
Take a matrix of tree calibrations,
 a matrix of tree predictions,
 a matrix of assembly motifs,
 and return statistics of each observed assembly motif.
}
\details{
The different assembly motifs have different length:
the motif set can be treated as a list.
Each assembly motif is separately analysed.

\itemize{
 \item \code{uTab}: the assemblages that belong to the assembly motif,
 \item \code{uMean}: the arithmetic mean of motif performances,
 \item \code{uSd}: the standard deviation of motif performances,
 \item \code{uRmse}: the Root Mean Square Error of motif performances,
 \item \code{uR2}: the Coefficient of determination of motif performances,
 \item \code{uSlope}:
 the slope of linear regression with motif performances.
}
}
\keyword{internal}
