% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_pca.mfd.R
\name{pca_mfd}
\alias{pca_mfd}
\title{Multivariate functional principal components analysis}
\usage{
pca_mfd(mfdobj, scale = TRUE, nharm = 20)
}
\arguments{
\item{mfdobj}{A multivariate functional data object of class mfd.}

\item{scale}{If TRUE, it scales data before doing MFPCA
using \code{scale_mfd}. Default is TRUE.}

\item{nharm}{Number of multivariate functional principal components
to be calculated. Default is 20.}
}
\value{
Modified \code{pca.fd} object, with
multivariate functional principal component scores summed over variables
(\code{fda::\link[fda]{pca.fd}} returns an array of scores
when providing a multivariate functional data object).
Moreover, the multivariate functional principal components
given in \code{harmonics}
are converted to the \code{mfd} class.
}
\description{
Multivariate functional principal components analysis (MFPCA)
performed on an object of class \code{mfd}.
It is a wrapper to \code{fda::\link[fda]{pca.fd}},
providing some additional arguments.
}
\examples{
library(funcharts)
mfdobj <- data_sim_mfd()
pca_obj <- pca_mfd(mfdobj)
plot_pca_mfd(pca_obj)

}
\seealso{
\code{\link{scale_mfd}}
}
