% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretize.R
\name{convert_df_to_categoric}
\alias{convert_df_to_categoric}
\title{Convert every column in a data frame to character}
\usage{
convert_df_to_categoric(data, n_bins)
}
\arguments{
\item{data}{input data frame to discretize}

\item{n_bins}{number of bins/segments for each variable}
}
\value{
data frame containing all variables as character
}
\description{
It converts all the variables present in 'data' to character. Criteria conversion is based on
two functions, \code{\link{discretize_get_bins}} plus \code{\link{discretize_df}}, which will discretize
all the numerical variables based on equal frequency criteria, with the number of bins equal to 'n_bins'.
This only applies for numerical variables which unique valuesare more than 'n_bins' parameter.
After this step, it may happen that variables remain non-character, so these variables will be converting
directly into character.
}
\examples{
\donttest{
# before
df_status(heart_disease)

# after
new_df=convert_df_to_categoric(data=heart_disease, n_bins=5)
df_status(new_df)
}
}
