% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretize.R
\name{discretize_rgr}
\alias{discretize_rgr}
\title{Variable discretization by gain ratio maximization}
\usage{
discretize_rgr(input, target, min_perc_bins = 0.1, max_n_bins = 5)
}
\arguments{
\item{input}{numeric input vector to discretize}

\item{target}{character or factor multi-calss target variable}

\item{min_perc_bins}{minimum percetange of rows for each split or segment (controls the sample size), 0,1 (or 10 percent) as default}

\item{max_n_bins}{maximum number of bins or segments to split the input variable, 5 bins as default}
}
\value{
discretized variable (factor)
}
\description{
Discretize numeric variable by maximizing the information gain
between each bucket and the target variable. Each cut point is recusivelly selected based on
}
\examples{
\dontrun{
library(funModeling)
data=heart_disease
input=data$oldpeak
target=as.character(data$has_heart_disease)

input2=discretize_rgr(input, target)

# checking:
summary(input2)
}
}
