% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/models_lib.R
\name{desc_groups}
\alias{desc_groups}
\title{Profiling categorical variable (rank)}
\usage{
desc_groups(data, group_var, group_func = mean, add_all_data_row = T)
}
\arguments{
\item{data}{input data source}

\item{group_var}{variable to make the group by}

\item{group_func}{the data type of this parameter is a function, not an string, this is the function to be used in the group by, the default value is: mean}

\item{add_all_data_row}{flag indicating if final data contains the row: 'All_Data', which is the function applied regardless the grouping. Useful to compare with the rest of the values.}
}
\value{
grouped data frame
}
\description{
Calculate the means (or other function) per group to analyze how each segment behave. It scales each variable mean inti the 0 to 1 range to easily profile the groups according to its mean. It also calculate the mean regardless the grouping. This function is also useful when you want to profile cluster results in terms of its means. It automatically adds a row representing the sumarization of the column regardless the group_var categories, this is useful to compare each segement with the whole population. It will exclude all factor/character variables.
}
\examples{
# default grouping function: mean
desc_groups(data=mtcars, group_var="cyl")

# using the median as the grouping function
desc_groups(data=mtcars, group_var="cyl", group_func=median)

# using the max as the grouping function
desc_groups(data=mtcars, group_var="gear", group_func=max)
}

